import { Observable } from 'rxjs/Observable';
import { Injectable } from '@angular/core';

import { SearchService } from './../../oneit/services/search.service';
import { UtilsService } from './../../oneit/services/utils.service';

@Injectable()
export class EditJobService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    

    getSelectWorkflows(assocs): Observable<any> {
        return this.searchService.getObjects("", "All", {}, assocs, null, null, null, null)
                .map(
                    data => {
                        return this.utilsService.convertResponseToObjects(data, assocs);
                    }
                );
    }

    getJobByID(id, assocs): Observable<any> {
        return this.searchService.getObjectById("", id, assocs)
            .map(
                data => {
                    let objs    =   this.utilsService.convertResponseToObjects(data, assocs);
                    
                    if(objs && objs.length > 0){
                        return objs[0];
                    }
                }
            );
    }
    
}