package performa.form;

import javax.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.DateDiff;
import performa.orm.Job;
import performa.orm.ShortenedURL;
import performa.orm.types.JobStatus;


public class SaveJobFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   process.getAttribute("Job") != null ? (Job) process.getAttribute("Job") : (Job) request.getAttribute("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"In SaveJobFP saving job : ", job );

        Job oldJob  = (Job) job.getEarliestBackup();

        if(oldJob != null && oldJob.getJobStatus() == JobStatus.DRAFT && job.getJobStatus() == JobStatus.OPEN)
        {
            job.setApplyBy(DateDiff.add(DateDiff.getToday(), Calendar.DATE, 30));
            job.setOpenDate(new Date());
        }
        
        if(job.getJobStatus() == JobStatus.OPEN && job.getShortenedURL() == null)
        {
            job.createShortenedURL();
        }
        
        return super.processForm(process, submission, params);
    }
}