import { Component, OnDestroy, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import * as moment from 'moment';
import { WorkPreferenceQuestionModel } from '../../models/work-preference-question.model';
import { takeUntil } from 'rxjs/operators';
import { AssessmentService } from '../../services/assessment.service';
import { Router } from '@angular/router';
import { HelperService } from '../../services/helper.service';

@Component({
  selector: 'app-work-preference',
  templateUrl: './work-preference.component.html',
  styleUrls: ['./work-preference.component.scss']
})

export class WorkPreferenceComponent extends BaseComponent implements OnInit, OnDestroy {

    workPreferenceQuestion = new WorkPreferenceQuestionModel();
    assocs = ['CultureElement'];
    answerScales = [];
    autoSaveInterval;
    autoSavedOn;
    autoSaveLabel = '';

  constructor(
      private as: AssessmentService,
      private hs: HelperService,
      private r: Router
  ) {
      super();
  }

  ngOnInit() {
      this.initiateWorkPreference();
      this.setAutoSaveInterval();
  }

    initiateWorkPreference(): void {
        this.isLoading = true;
        this.as.getWorkPreferences(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                console.log(response);
                this.isLoading = false;
                this.autoSavedOn = new Date();
                if (response.length > 0) {
                    this.workPreferenceQuestion = response[0];
                }
            }, err => {
                this.isLoading = false;
                this.hs.handleHttpError(err);
            });
    }

    setAutoSaveInterval(): void {
        if (!this.autoSaveInterval) {
            setInterval(() => {
                this.autoSave();
            }, 60000);
        }
    }

    autoSave(): void {
        this.autoSaveLabel = moment(this.autoSavedOn).fromNow();
    }

    exit(): void {
        this.r.navigate(['/my-career-web/dashboard/home']);
    }

    ngOnDestroy(): void {
        super.ngOnDestroy();
        if (this.autoSaveInterval) {
            clearInterval(this.autoSaveInterval);
        }
    }

}
