/**
 * Reference : https://stripe.com/docs/stripe-js#elements
 */

// Create a Stripe client
var stripe = Stripe(stripePubKey);

var form = document.getElementById('makePayment');

form.addEventListener('submit', function(event) {
    event.preventDefault();

    var cardExpiry = document.getElementById('cardExpiry').value;

    if(cardExpiry.length !== 0 && !Stripe.card.validateExpiry(cardExpiry))
    {
        var displayError = document.getElementById('card-errors');
        displayError.textContent = "Please enter a valid expiry";
    }
    else
    {
        $('input[name=expiry-date]').val(document.getElementById('cardExpiry').value);
        $('input[name=holder-name]').val(document.getElementById('NameOnCard').value);
        $('input[name=address-zip]').val(document.getElementById('PostCode').value);
        $('#payNow').click();
    }
});