
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CultureNarrativePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea CultureNarrativePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "CultureNarrative");

    // Private attributes corresponding to business object data
    private String dummyNotes;
    private ColorCode dummyColorCode;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Notes = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ColorCode = new EnumeratedAttributeHelper (ColorCode.FACTORY_ColorCode);
    



    public CultureNarrativePersistenceMgr ()
    {
        dummyNotes = (String)(HELPER_Notes.initialise (dummyNotes));
        dummyColorCode = (ColorCode)(HELPER_ColorCode.initialise (dummyColorCode));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_culture_narrative.object_id as id, {PREFIX}tl_culture_narrative.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_culture_narrative.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_culture_narrative.narrative_notes, {PREFIX}tl_culture_narrative.color_code, {PREFIX}tl_culture_narrative.culture_element_number, {PREFIX}tl_culture_narrative.culture_element_quest_id, {PREFIX}tl_culture_narrative.culture_element_rating_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, CultureNarrative.REFERENCE_CultureNarrative);

                if (objectToReturn instanceof CultureNarrative)
                {
                    LogMgr.log (CultureNarrativePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a CultureNarrative");
                }
            }

            PersistentSet tl_culture_narrativePSet = allPSets.getPersistentSet(id, "tl_culture_narrative", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_culture_narrativePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_culture_narrativePSet.containsAttrib(CultureNarrative.FIELD_Notes)||
                    !tl_culture_narrativePSet.containsAttrib(CultureNarrative.FIELD_ColorCode)||
                    !tl_culture_narrativePSet.containsAttrib(CultureNarrative.SINGLEREFERENCE_CultureElement)||
                    !tl_culture_narrativePSet.containsAttrib(CultureNarrative.SINGLEREFERENCE_CultureElementQuestion)||
                    !tl_culture_narrativePSet.containsAttrib(CultureNarrative.SINGLEREFERENCE_CultureElementRating))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CultureNarrativePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                CultureNarrative result = new CultureNarrative ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_culture_narrative " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_culture_narrative.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (CultureNarrative.SINGLEREFERENCE_CultureElement))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_culture_narrative " +
                            "WHERE " + SELECT_JOINS + "culture_element_number = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (CultureNarrative.SINGLEREFERENCE_CultureElementQuestion))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_culture_narrative " +
                            "WHERE " + SELECT_JOINS + "culture_element_quest_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (CultureNarrative.SINGLEREFERENCE_CultureElementRating))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_culture_narrative " +
                            "WHERE " + SELECT_JOINS + "culture_element_rating_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_culture_narrativePSet = allPSets.getPersistentSet(objectID, "tl_culture_narrative");
            

            
            if (tl_culture_narrativePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_culture_narrativePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_culture_narrative " +
                                                           "SET narrative_notes = ?, color_code = ?, culture_element_number = ? , culture_element_quest_id = ? , culture_element_rating_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_culture_narrative.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Notes.getForSQL(dummyNotes, tl_culture_narrativePSet.getAttrib (CultureNarrative.FIELD_Notes))).listEntry (HELPER_ColorCode.getForSQL(dummyColorCode, tl_culture_narrativePSet.getAttrib (CultureNarrative.FIELD_ColorCode))).listEntry (SQLManager.CheckNull((Long)(tl_culture_narrativePSet.getAttrib (CultureNarrative.SINGLEREFERENCE_CultureElement)))).listEntry (SQLManager.CheckNull((Long)(tl_culture_narrativePSet.getAttrib (CultureNarrative.SINGLEREFERENCE_CultureElementQuestion)))).listEntry (SQLManager.CheckNull((Long)(tl_culture_narrativePSet.getAttrib (CultureNarrative.SINGLEREFERENCE_CultureElementRating)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_culture_narrative WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_culture_narrative", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CultureNarrativePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_culture_narrative");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_culture_narrative for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CultureNarrativePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_culture_narrativePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CultureNarrativePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_culture_narrativePSet = allPSets.getPersistentSet(objectID, "tl_culture_narrative");
        

        LogMgr.log (CultureNarrativePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_culture_narrativePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_culture_narrativePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_culture_narrative " +
                                                       "WHERE tl_culture_narrative.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_culture_narrative WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_culture_narrative");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_culture_narrative for row:" + objectID;

                    LogMgr.log (CultureNarrativePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_culture_narrativePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, CultureNarrative> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (CultureNarrative.REFERENCE_CultureNarrative.getObjectIDSpace (), r.getLong ("id"));
            CultureNarrative resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, CultureNarrative.REFERENCE_CultureNarrative);

                if (cachedElement instanceof CultureNarrative)
                {
                    LogMgr.log (CultureNarrativePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (CultureNarrative)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a CultureNarrative");
                }
            }
            else
            {
                PersistentSet tl_culture_narrativePSet = allPSets.getPersistentSet(objectID, "tl_culture_narrative", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new CultureNarrative ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CultureNarrativePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_culture_narrative " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (CultureNarrative.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_culture_narrative.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_culture_narrative.object_id is not null
                    String preFilter = "(tl_culture_narrative.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_culture_narrative " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_culture_narrativePSet = allPSets.getPersistentSet(objectID, "tl_culture_narrative", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_culture_narrativePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_culture_narrativePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_culture_narrativePSet.setAttrib(CultureNarrative.FIELD_Notes, HELPER_Notes.getFromRS(dummyNotes, r, "narrative_notes"));
        tl_culture_narrativePSet.setAttrib(CultureNarrative.FIELD_ColorCode, HELPER_ColorCode.getFromRS(dummyColorCode, r, "color_code"));
        
        tl_culture_narrativePSet.setAttrib(CultureNarrative.SINGLEREFERENCE_CultureElement, r.getObject ("culture_element_number"));
        tl_culture_narrativePSet.setAttrib(CultureNarrative.SINGLEREFERENCE_CultureElementQuestion, r.getObject ("culture_element_quest_id"));
        tl_culture_narrativePSet.setAttrib(CultureNarrative.SINGLEREFERENCE_CultureElementRating, r.getObject ("culture_element_rating_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_culture_narrativePSet = allPSets.getPersistentSet(objectID, "tl_culture_narrative");
        

        
        if (tl_culture_narrativePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_culture_narrativePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_culture_narrative " +
                                     "  (narrative_notes, color_code,  culture_element_number, culture_element_quest_id, culture_element_rating_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?,  ?, ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Notes.getForSQL(dummyNotes, tl_culture_narrativePSet.getAttrib (CultureNarrative.FIELD_Notes))).listEntry (HELPER_ColorCode.getForSQL(dummyColorCode, tl_culture_narrativePSet.getAttrib (CultureNarrative.FIELD_ColorCode))) .listEntry (SQLManager.CheckNull((Long)(tl_culture_narrativePSet.getAttrib (CultureNarrative.SINGLEREFERENCE_CultureElement)))).listEntry (SQLManager.CheckNull((Long)(tl_culture_narrativePSet.getAttrib (CultureNarrative.SINGLEREFERENCE_CultureElementQuestion)))).listEntry (SQLManager.CheckNull((Long)(tl_culture_narrativePSet.getAttrib (CultureNarrative.SINGLEREFERENCE_CultureElementRating)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_culture_narrativePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
