package performa.orm;

import oneit.objstore.ObjectTransaction;
import oneit.security.SecUser;
import oneit.utils.CollectionUtils;
import oneit.utils.StringUtils;


public class AdminUser extends BaseAdminUser
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public AdminUser ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    
    public static AdminUser getAdminUserForForgotPassword(ObjectTransaction transaction, String userIDStr, String code)
    {
        userIDStr   =   StringUtils.subBlanks(userIDStr);
        code        =   StringUtils.subBlanks(code);
        
        if(userIDStr != null && code!=null)
        {
            AdminUser adminUser = AdminUser.getAdminUserByID(transaction, Long.parseLong(userIDStr));
                        
            if(adminUser != null && CollectionUtils.equals(adminUser.getForgotPasswordKey(), code))
            {
                return adminUser;
            }
        }
        
        return null;
    }
}

    
