import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';


@Injectable()
export class ViewCareerUserService {
    
    constructor(
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {
    }
    
    getCareerUserByID(id, assocs): Observable<any> {
        return this.searchService.getObjectById("CareerProfiles", id, assocs)
            .map(
                data => {
                    let objs    =   this.utilsService.convertResponseToObjects(data, assocs);
                    
                    if(objs && objs.length > 0){
                        return objs[0];
                    }
                }
            );
    }
}