<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran     =   process.getTransaction ();
    String              currentPage =   WebUtils.getSamePageInRenderMode(request, "SignIn");
    String              nextPage    =   WebUtils.getArticleLink(request, objTran, WebUtils.JOB_APPLICATION, "Page");
    Job                 job         =   (Job) process.getAttribute("Job");
    Candidate           candidate   =   (Candidate) process.getAttribute("NewCandidate");
            
    if(request.getParameter("JobID")!=null)
    {
        job =   Job.getJobByID(transaction, Long.parseLong((String) request.getParameter("JobID")));
    }
    
    //to process candidate verification
    String              id          =   request.getParameter("id");
    String              key         =   request.getParameter("key");
    String              candidateId =   request.getParameter("aid");
    String              pin         =   request.getParameter("pin");
    
    if(id != null && key != null)
    {
        job = Job.searchJobKey(transaction, Long.parseLong(id), key);
    }
    
    if(candidateId!=null && pin!=null)
    {
        candidate   =   Candidate.searchIdPin(transaction, Long.parseLong(candidateId), pin);
        
        if(candidate!=null && candidate.getIsAccountVerified()==Boolean.TRUE)
        {
            response.setStatus(404);
            return;
        }
    }
    
    process.setAttribute("Job", job);
    process.setAttribute("NewCandidate", candidate);
    
    Debug.assertion(job != null, "Job is null in applicant portal");
%>
    <script type="text/javascript">
        $(document.body).addClass('bg-color');
        
        $(document).ready(function() {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
           
            $('.send-link-btn').attr('disabled', 'disabled');
            $('input[type="password"]').keyup(function() {
               if($(this).val() != '') {
                   $('.sign-in-btn').removeAttr('disabled');
               } else {
                   $('.sign-in-btn').attr('disabled', 'disabled');
               }
            });
            
            $('.reset-pw-btn').attr('disabled', 'disabled');
            $('.reset-pw').keyup(function() {
                var empty = false;
               
                $('input.reset-pw').each(function() {
                    if ($( this ).val() == '') {
                        empty = true;
                    }
                });
                
                if(empty) {
                   $('.reset-pw-btn').attr('disabled', 'disabled');
                } else {
                   $('.reset-pw-btn').removeAttr('disabled');
                }
            });
        });
    </script>
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
        
        #email-div {
            position: relative;
        }
        
        #right-mark {
            width: 30px;
            height: 30px;
            border-radius: 30px;
            position: absolute;
            top: 50%;
            right: -14px;
            background-color: green;
            padding-top: 5px;
        }
        
        #right-mark img {
            width: 20px;
            height: 20px;
            display: block;
            margin: auto auto;
        }
    </style>
    
    <oneit:form name="applyJob" method="post"   enctype="multipart/form-data">

        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="main-verify-identity">
            <div class="verify-aust-logo"><img src="images/australia-post.png"></div>
            <div class="pl-verify">Please verify your identity before applying to:</div>
            <div class="verify-i-title">
                <oneit:toString value="<%= job.getPageTitle() %>"   mode="EscapeHTML"/>
            </div>
            <div class="main-box-layout verify-i-setpone">
 
                <%
                    if(candidate==null)
                    {
                %>
<!--                        <div class="box-label">Sign in using your social network of choice</div>
                        <ul class="social-login">
                            <li><a href="#"><img src="images/login-linkedin-icon.svg"></a></li>
                            <li><a href="#"><img src="images/login-facebok-icon.svg"></a></li>
                            <li><a href="#"><img src="images/login-google.png"></a></li>
                        </ul>
                        <div class="box-br-line"><span></span></div>-->
                        <!--<div class="box-label">Or sign in via email</div>-->
                        <div class="box-label">Sign in via email</div>
                        <div class="form-group text-left" id="email-div">
                            <label>Email Address</label>
                            <oneit:ormInput obj="<%= job %>"    type="text" attributeName="Email"   cssClass="form-control second-style" />
                            <oneit:recalcClass  htmlTag="div"   classScript="job.isEmailFound() ? 'show': 'hide'"  job="<%= job %>"    class="right-mark">
                                <span id="right-mark"><img src="images/right-mark.svg"/></span>
                            </oneit:recalcClass>
                        </div>

                        <oneit:recalcClass  htmlTag="div"   classScript="job.isEmailFound() ? 'show': 'hide'"  job="<%= job %>">
                            <div class="form-group text-left">
                                <label>Password</label>
                                <oneit:ormInput obj="<%= job %>"    type="password" attributeName="Password"    cssClass="form-control second-style" />
                            </div>
                            <div class="form-group">
                            <oneit:button   value="Sign In"     name="signIn"   cssClass="box-btn   sign-in-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("Job",job)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>"/>
                            </div>
                        </oneit:recalcClass>

                        <oneit:recalcClass  htmlTag="div"   classScript="job.getEmail()==null || job.isEmailFound() ? 'hide': 'show'"  job="<%= job %>">
                            <div class="form-group">
                                <oneit:button   value="Send link"   name="sendVerificationMail"    cssClass="box-btn"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                .mapEntry("Job",job)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                                .mapEntry("restartProcess", Boolean.TRUE)
                                                                                .mapEntry("attribNamesToRestore", "Job")
                                                                                .mapEntry("attribNamesToRestore", Collections.singleton("Job"))
                                                                                .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "emailSent")
                                                                                .toMap() %>"/>
                            </div>
                        </oneit:recalcClass>
                <%
                    }
                    else
                    {
                        SecUser secUser =   candidate.getUser();
                        
                        job.setEmail(secUser.getUserName());
                %>
                        <div class="form-group text-left">
                            <label>Email Address</label>
                            <oneit:ormInput obj="<%= job %>"    type="text" attributeName="Email"   cssClass="form-control second-style" disabled="true"    readonly="true"/>
                        </div>
                        <div class="form-group text-left">
                            <label>Password</label>
                            <oneit:ormInput obj="<%= job %>"    type="password" attributeName="Password"        cssClass="form-control second-style reset-pw"/>
                        </div>
                        <div class="form-group text-left">
                            <label>Confirm password</label>
                            <oneit:ormInput obj="<%= job %>"    type="password" attributeName="ConfirmPassword" cssClass="form-control second-style reset-pw"/>
                        </div>
                        <div class="form-group">
                            <oneit:button   value="Sign In"     name="resetPassword"   cssClass="box-btn   reset-pw-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("Job",job)
                                                                            .mapEntry("NewCandidate",candidate)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>"/>
                        </div>
                <%
                    }
                %>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>