import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';

import { AccessDeniedComponent } from './oneit/components/access-denied/access-denied.component';
import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { HomeComponent } from './oneit/components/home/home.component';
import { IframePageComponent } from './oneit/components/iframe-page/iframe-page.component';

import { AuthGuard } from './oneit/guards/auth.guard';


export const routes: Routes = [
    {
        path: '',
        redirectTo: 'home',
        pathMatch: 'full',
    },
    {
        path: '',
        component: FullLayoutComponent,
        data: {
            showDefaultHeader: true,
            showDefaultFooter: true,
            showMenu: true,
            showFeedback: true
        },
        children: [
            {
                path: 'access-denied',
                component: AccessDeniedComponent
            },
            {
                path: 'home',
                canActivate: [AuthGuard],
                component: HomeComponent
            },
            {
                path: 'iframe-page/:url',
                canActivate: [AuthGuard],
                component: IframePageComponent,
                runGuardsAndResolvers: 'always'
            }
            // Project ROUTES will appear here, serach-client added for example
            // {
            //     path: 'search-client',
            //     component: SearchClientComponent,
            //     canActivate: [AuthGuard],
            //     data: {privs: [Constants.PRIV_SALES_MANAGER, Constants.PRIV_READ_ONLY]}
            // }
        ]
    },
    // CUSTOM HEADER Example e.g. Public Page
    // {
    //     path: '',
    //     component: FullLayoutComponent,
    //     data: {
    //         defaultFooter : false,
    //         defaultHeader: false,
    //         customHeader: CustomHeaderComponent
    //     },
    //     children: [
    //         {
    //             path: 'publicPage',
    //             component: PublicPageComponent
    //         }
    //     ]
    // }
    // Don't forget to add below line in app.module.ts
    // entryComponents: [CustomHeaderComponent],
];

@NgModule({
    imports: [RouterModule.forRoot(routes, { useHash: true, onSameUrlNavigation: 'reload' })],
    exports: [RouterModule]
})
export class AppRoutingModule { }
