<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "forgot_password_jsp"; } %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<script type="text/javascript">
    $(document).ready(function() {
        recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});

        validate();
        
        $('input[type="text"]').keyup(function() {
            $(this).change();
            validate();
        });
        
        $('#right-mark-div').onChange(function() {
            alert($(this).attr('class'));
        });
    });

    function validate() {
        if ($('#send-link-div')) {
            $('.send-btn').attr('disabled', 'disabled');
        } else {
            $('.send-btn').removeAttr('disabled');
        }
    }
</script>
<style>
    .btn-disabled button{
        opacity: 0.6;
        background-color: #0582ba;
    }

    #right-mark {
        width: 24px;
        height: 24px;
        border-radius: 30px;
        position: absolute;
        top: 51%;
        right: 37px;
        background-color: #67b413;
        padding-top: 5px;
    }

    #right-mark img {
        width: 15px;
        height: 15px;
        display: block;
        margin: auto auto;
    }
</style>
<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();
    CompanyUser         companyUser =   CompanyUser.createCompanyUser(objTran);
%>
    <oneit:form name="forgotPassword"    method="post"   enctype="multipart/form-data">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        <div class="main-box-layout login-box">
            <div class="text-justify">
                <p>
                    Enter your email address below. If we find a matching account, then you'll receive an email with a password reset link.
                </p>
            </div>
            <div>&nbsp;</div>
            <div class="form-group text-left">
                <label>Email Address</label>
                <oneit:ormInput obj="<%= companyUser %>"    type="text" attributeName="Email"   cssClass="form-control" autocomplete="off"/>
                <oneit:recalcClass  id="right-mark-div"  htmlTag="div"   classScript="companyUser.emailExists() ? 'show': 'hide'"    companyUser="<%= companyUser %>"    class="right-mark">
                    <span id="right-mark"><img src="../../images/right-mark.svg"/></span>
                </oneit:recalcClass>
            </div>
            <div class="form-group">
                <oneit:recalcClass  id="right-mark-div"  htmlTag="div"   classScript="companyUser.emailExists() ? 'show': 'btn-disabled'"    companyUser="<%= companyUser %>"    class="right-mark">
                    <oneit:button   value="Send reset link"     name="forgotPassword"   cssClass="box-btn send-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "sign_in.jsp?sent=true")
                                                                    .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "resetPasswordEmailSent")
                                                                    .toMap() %>"/>
                </oneit:recalcClass>
            </div>
        </div>
    </oneit:form>

<%@ include file="inc/htmlfooter_nopriv.jsp" %>