import { AfterViewInit, HostListener, OnDestroy } from '@angular/core';
import { Subject } from 'rxjs';

export class BaseComponent implements AfterViewInit, OnDestroy {

    isEditMode = false;
    isLoading = false;
    isSaving = false;
    isMobileView = false;
    resizeTimeout = 500;
    createdObjs = {};
    updatedObjs = {};
    deletedObjs = {};

    protected componentInView = new Subject();

    @HostListener('window:resize')
    onWindowResize() {
        //debounce resize, wait for resize to finish before doing stuff
        if (this.resizeTimeout) {
            clearTimeout(this.resizeTimeout);
        }
        this.resizeTimeout = setTimeout((() => {
            this.isMobileView = document.body.getBoundingClientRect().width <= 1024;
        }), 500);
    }

    ngAfterViewInit(): void {
        setTimeout(() => {
            this.isMobileView = document.body.getBoundingClientRect().width <= 1024;
        }, 100);
    }


    ngOnDestroy(): void {
        this.componentInView.next();
        this.componentInView.complete();
    }

}
