package performa.orm;

import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import oneit.objstore.MessageSource;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.rdbms.filters.IsNotNullFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.servlets.objstore.MessageSourceDecorator;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.CollectionUtils;
import oneit.utils.DateDiff;
import oneit.utils.ObjectTransform;
import oneit.utils.StringUtils;
import oneit.utils.filter.*;
import performa.utils.ExpressAnswerFilter;


public class Candidate extends BaseCandidate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public Candidate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    
    public String getFirstName()
    {
        return getUser() != null ? getUser().getFirstName() : null;
    }

    
    @Override
    public String getToString() 
    {
        return getUser() != null ? getUser().getName() : null;
    }   

    
    public static String checkCandidate(HttpServletRequest request, ORMProcessState process)
    {
        ObjectTransaction   transaction         =   process.getTransaction();
        String              candidateID         =   (String) request.getParameter("id");
        String              verificationCode    =   (String) request.getParameter("pin");
        MessageSource       messageSource       =   MessageSourceDecorator.getMessageSource(request);
        Candidate           candidate           =   null;
        String              errorMsg            =   "";
        
        if(StringUtils.subBlanks(candidateID) != null && StringUtils.subBlanks(verificationCode) != null)
        {
            candidate = Candidate.getCandidateByID(transaction, Long.parseLong(candidateID));
            
            process.setAttribute("Candidate", candidate);
        }
        else if(process.getAttribute("Candidate") != null)
        {
            candidate = (Candidate) process.getAttribute("Candidate");
        }
        else
        {
            errorMsg = messageSource.getFieldErrorMsg(Candidate.REFERENCE_Candidate, "", "UnauthorizedUser", null);
        }

        if(candidate == null)
        {
            errorMsg = messageSource.getFieldErrorMsg(Candidate.REFERENCE_Candidate, "", "UnauthorizedUser", null);
        }
        else if(!CollectionUtils.equals(verificationCode, candidate.getVerificationKey()))
        {
            errorMsg = messageSource.getFieldErrorMsg(Candidate.REFERENCE_Candidate, "", "WrongVerificationCode", null);
        }
        else if(DateDiff.getDateDiff(Calendar.HOUR, candidate.getVerificationMailSendDate(), new Date()) > 24)
        {
            errorMsg = messageSource.getFieldErrorMsg(Candidate.REFERENCE_Candidate, "", "LinkExpired", null);
        }
        
        return errorMsg;
    }
    
    
    public TestAnalysis getTestAnalysisFor(Level level)
    {
        Filter<TestAnalysis>    testAnalysisFilter  =   TestAnalysis.SearchByAll().andLevel(new EqualsFilter(level));
           
        return pipelineCandidate().toTestAnalysises(testAnalysisFilter).val();
    }
    

    public boolean cultureCompleted(Job job)
    {
        int allAnswersCount =   getCultureCriteriaAnswersCount();
        
        if(allAnswersCount == job.getCultureCriteriasCount())
        {
            Filter      filter          =   CultureCriteriaAnswer.SearchByAll().andSelectedQuestion(new IsNotNullFilter<>());
            Collection  selectedAnswers =   pipelineCandidate().toCultureCriteriaAnswers(filter).vals();

            return (selectedAnswers.size() == allAnswersCount);
        }
        
        return false;
    }
    
    public double cultureCompletedPercentage(Job job)
    {
        return (getCultureCriteriaAnswersCount() * 100) / job.getCultureCriteriasCount() ;
    }
    
    public double roleFitCompletedPercentage(Job job)
    {
        return (getCompletedAnswers(job).size() * 100) / job.getAllQuestions().size() ;
    }
    
    public Collection<Answer> getCompletedAnswers(Job job)
    {
        return CollectionFilter.filter(getProfileAssessmentAnswersSet(), new ExpressAnswerFilter(job.isExpressJob()));
    }
    
    public boolean assessmentCompleted(Job job) //role
    {
        int allAnswersCount =   job.getAllQuestions().size();
        
        if(allAnswersCount > 0)
        {
            Collection  selectedAnswers =   getCompletedAnswers(job);
            
            return (selectedAnswers.size() >= allAnswersCount);
        }
        return false;
    }
    
    
    public List<CultureCriteriaAnswer> getSortedCultureCriteriaAnswers()
    {
        return  ObjstoreUtils.sort(getCultureCriteriaAnswersSet(), 
                                new ObjectTransform[] {CultureCriteriaAnswer.pipesCultureCriteriaAnswer().toObjectID()},  
                                new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR});
    }
    
    
    public static Candidate getCandidateForForgotPassword(ObjectTransaction transaction, String userIDStr, String code)
    {
        userIDStr   =   StringUtils.subBlanks(userIDStr);
        code        =   StringUtils.subBlanks(code);
        
        if(userIDStr != null && code!=null)
        {
            Candidate   candidate   =   Candidate.getCandidateByID(transaction, Long.parseLong(userIDStr));
                        
            if(candidate != null && CollectionUtils.equals(candidate.getForgotPasswordKey(), code))
            {
                return candidate;
            }
        }
        
        return null;
    }
    
    public boolean showPrivacyPolicyAgreed()
    {
        return isTrue(getPrivacyPolicyAgreed());
    }
    
    public boolean showConditionsAgreed()
    {
        return isTrue(getConditionsAgreed());
    }
}