<%@ page extends="oneit.servlets.jsp.FormJSP"%>
<%@ include file="/setuprequest.jsp"%>
<%@ include file="inc/stdimports.jsp"%>
<%@ include file="/editor/stdimports.jsp"%>

<%@ page import="oneit.servlets.jsp.ormtable.*" %>

<%! protected String getName (ServletConfig config) { return "setupPlans_jsp"; } %>
<%
    ORMProcessState     process     = (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     = process.getTransaction ();
    StripePlanNPO       plan        = (StripePlanNPO) process.getAttribute("StripePlanNPO");
    
    if(plan == null)
    {
        plan = StripePlanNPO.createStripePlanNPO(objTran);

        process.setAttribute("StripePlanNPO", plan);

        %><%@include file="/saferedirect.jsp"%><%
    }
    
    ORMTableCellStyle           commonCellStyle     = new ORMTableCellStyle("nofilter nosort");
    BaseBusinessClassFactory    currencyPlanFactory = new BaseBusinessClassFactory(CurrencyPlanNPO.REFERENCE_CurrencyPlanNPO, objTran)
                                                                        .onInitSetSingleAssoc("Plan", plan ); 

    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "SetupPlan").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "Setup Stripe Plans");
%>

<%@include file="/editor/header.jsp"%>


    <oneit:layout_total widths="<%= new double[] {1, 4, 6} %>" skin="bootstrap">
        <oneit:skin tagName="layout_row">
            <oneit:layout_label width="1"><oneit:ormlabel    obj="<%= plan %>"  field="ProductID" /></oneit:layout_label>
            <oneit:layout_field width="1">
                <oneit:ormInput obj="<%= plan %>"  attributeName="ProductID" type="text" class="form-control"    required="required"/>
            </oneit:layout_field>
        </oneit:skin>
        <oneit:skin tagName="layout_row">
            <oneit:layout_label width="1"><oneit:ormlabel    obj="<%= plan %>"  field="PlanName" /></oneit:layout_label>
            <oneit:layout_field width="1">
                <oneit:ormInput obj="<%= plan %>"  attributeName="PlanName" type="text" class="form-control"    required="required"/>
            </oneit:layout_field>
        </oneit:skin>
        <oneit:skin tagName="layout_row">
            <oneit:layout_label width="1"><oneit:ormlabel    obj="<%= plan %>"  field="ActiveJobs" /></oneit:layout_label>
            <oneit:layout_field width="1">
                <oneit:ormInput obj="<%= plan %>"  attributeName="ActiveJobs" type="text" class="form-control"    required="required"/>
            </oneit:layout_field>
        </oneit:skin>
        <oneit:skin tagName="layout_row">
            <oneit:layout_field width="2">
                <oneit:ormtable class="ormtable cougartable" tableId="currency-plan-list" 
                                rowObjFactory="<%= currencyPlanFactory %>" 
                                rowObjects="<%= plan.getCurrencyPlansSet() %>" 
                                customiser="<%= new TableCustomiser() %>">

                    <oneit:ormcol   expression="CurrencyType"   width="3"   mode="ormEnum"  cellStyle="<%= commonCellStyle %>"/>
                    <oneit:ormcol   expression="PerJobAmount"   width="4"   mode="text"     cellStyle="<%= commonCellStyle %>"/>
                    <oneit:ormcol   expression="Amount"         width="4"   mode="text"     cellStyle="<%= commonCellStyle %>"/>

                    <oneit:ormcol   expression=""               width="0.1" mode="jsp"                  cellStyle="<%= commonCellStyle %>" 
                                    jspName="/extensions/standard/ormtable/deleteORMRowButton.jsp"  />
                </oneit:ormtable>

                <input type="button" value="Add" onclick="ormtable_addRow('currency-plan-list');"    style="float: right"    class="btn btn-default"/>
            </oneit:layout_field>
        </oneit:skin>
        <oneit:skin tagName="layout_row">
            <oneit:layout_field width="1">
                <oneit:button   value="Create Plan"    name="createPlan" cssClass="btn btn-primary"  requestAttribs='<%= CollectionUtils.EMPTY_MAP %>'/>
            </oneit:layout_field>
        </oneit:skin>
    </oneit:layout_total>

<%@include file="/editor/footer.jsp"%>