package performa.utils;

import oneit.utils.filter.Filter;
import performa.orm.Answer;

/**
 *
 * @author Harsh
 */
public class ExpressAnswerFilter implements Filter<Answer>
{
    private final boolean isExpressJob;

    public ExpressAnswerFilter(boolean isExpressJob)
    {
        this.isExpressJob = isExpressJob;
    }
    
    @Override
    public boolean accept(Answer answer)
    {
        if(answer != null && answer.getQuestion() != null)
        {
            return answer.getAnswerNo() != null && answer.getAnswerNo() != 0 && (answer.getQuestion().getIsExpressQuestion() == isExpressJob);
        }
        return false;
    }
}