package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import performa.orm.JobApplication;


public class SaveAndExitWorkStypeFP  extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        ObjectTransaction   objTran =   ObjectTransaction.getTransaction();
        Long                appID   =   (Long) process.getAttribute("JobApplicationID");
        JobApplication      jobApplication  =   JobApplication.getJobApplicationByID(objTran, appID);

        process.setAttribute("JobApplication", jobApplication);
        
        return super.processForm(process, submission, params);
    }
}