<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<oneit:dynIncluded>
<%
    String      nextPage    =   WebUtils.getSamePageInRenderMode(request, "CompanyProfile");
    String      homePage    =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.ADMIN_HOME).getLink(request) + "?firstTime=true"; ;
    CompanyUser companyUser =   (CompanyUser) process.getAttribute("CompanyUser");
    SecUser     secUser     =   null;
    Boolean     socialLogin =   Boolean.FALSE;

    //to process company user verification
    String      id          =   request.getParameter("id");
    String      verifyKey   =   request.getParameter("key");
    Boolean     invalid     =   Boolean.TRUE;
    
    if(id != null && verifyKey != null)
    {
        companyUser =   CompanyUser.searchIdPin(transaction, Long.parseLong(id), verifyKey);

        if(companyUser != null && companyUser.getIsAccountVerified() != Boolean.TRUE)
        {
            secUser =   companyUser.getUser();
            process.setAttribute("CompanyUser", companyUser);
            
            invalid =   Boolean.FALSE;
        }
    }
    
    if(invalid)
    {
        //to handle social login
        SecUser     logedInUser =   SecUser.getTXUser(transaction);
        companyUser             =   logedInUser != null ? logedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser) : null;
        
        if(logedInUser != null  
                && logedInUser.hasRole(Utils.ROLE_CLIENT) 
                && companyUser != null 
                && companyUser.getIsAccountVerified() != Boolean.TRUE)
        {
            socialLogin =   Boolean.TRUE;
            invalid     =   Boolean.FALSE;
        }
        
        if(invalid)
        {
            response.sendRedirect(WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.ADMIN_HOME).getLink(request));
        }
    }

    Debug.assertion(companyUser != null, "Invalid CompanyUser in admin portal");

    Company company = companyUser.getCompany();
    
    process.setAttribute("Company", company);
%>
    <oneit:script>
        <oneit:script src="/scripts/password_strength_lightweight.js"/>
    </oneit:script>
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
    </style>

    <oneit:form name="verify"    method="post">
        <%
            String  key =   Utils.getPwdKeyOfSecUser(request, secUser, true);
        %>
    <script type="text/javascript">
        $(document.body).addClass('bg-color');

        $(document).ready(function() {
            recalcFunction = setupRecalc ($("form#verify"), {'recalcOnError':true});
            validate();
            $('input').on('change keyup', function() { validate() });
            interval =  setInterval(function() { validate(); }, 500);
            
            $('#myPassword').strength_meter({
                "inputName" : "<%= key %>"
            });
            
        });
        
        function validate() {
            var empty = false;
            $('input[required]').each(function() {
                if ($( this ).val() == '') {
                    empty = true;
                    if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                       empty = false;
                    }
                }
            });
            
            if (<%= !socialLogin %> && (!$('input[name$=Password]').val() && !$('input[name$=Password2]').val())){
               empty = true; 
            }

            if (empty) {
                $('.verify-btn').attr('disabled', 'disabled');
            } else {
                $('.verify-btn').removeAttr('disabled');
//                 clearInterval(interval);
            }
        }
    </script>
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="main-box-layout login-box">
            <oneit:dynInclude   page="/extensions/adminportal/inc/company_user_data.jsp"    data="<%= CollectionUtils.EMPTY_MAP%>"  CompanyUser="<%= companyUser %>"
                                IncludePrivacyStatements="<%= Boolean.FALSE %>"/>
            
            <%
                if(!socialLogin)
                {
            %>
                    <div class="form-group text-left"   id="myPassword">
                        <label>Password</label>
                    </div>
                    <div class="form-group text-left">
                        <label>Confirm password</label>
                        <oneit:input    type="password" name="<%= key + 2 %>"   class="form-control second-style reset-pw"/>
                    </div>
            <%
                }

                if(companyUser.getCompany().getAddedByUser() == companyUser)
                {
            %>
                    <oneit:button   value="Create my account"  name="gotoPage"    cssClass="box-btn verify-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("socialLogin", socialLogin)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Company", companyUser.getCompany()).toMap())
                                                                    .mapEntry("nextPage", nextPage).toMap() %>"/>
            <%
                }
                else
                {
            %>
            
                    <div class="form-group text-left">
                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= companyUser %>"  id="privacy-policy-agreed"  attributeName="PrivacyPolicyAgreed" type="checkbox" />
                                <oneit:recalcClass  htmlTag="span"  classScript="companyUser.showPrivacyPolicyAgreed() ? 'checked': 'unchecked'"    companyUser="<%= companyUser %>">
                                    <label for="privacy-policy-agreed">
                                        <oneit:label GUIName="I have read and agree to the " />
                                        <a href="https://www.talentology.com/privacy/" target="_blank" class="privacy-link">Privacy Policy</a>
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                    </div>
                    <div class="form-group text-left">
                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= companyUser %>"  id="conditions-agreed"  attributeName="ConditionsAgreed" type="checkbox"   />
                                <oneit:recalcClass  htmlTag="span"  classScript="companyUser.showConditionsAgreed() ? 'checked': 'unchecked'"    companyUser="<%= companyUser %>">
                                    <label for="conditions-agreed">
                                        <oneit:label GUIName="I have read and agree to the " />
                                        <a href="https://www.talentology.com/terms-of-service/" target="_blank" class="privacy-link">Terms & Conditions</a>
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                    </div>
                                    
                    <oneit:button   value="Sign up"  name="sendCompanyUserInvites"   cssClass="box-btn verify-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("socialLogin", socialLogin)
                                                                                .mapEntry("CompanyUser", companyUser)
                                                                                .mapEntry("nextPage", homePage)
                                                                                .toMap() %>"/>
            <%
                }
            %>
        </div>
    </oneit:form>
</oneit:dynIncluded>
        
<%@ include file="inc/htmlfooter_nopriv.jsp" %>