import { CLASSES } from '../constants';
import { StageTypeEnum } from './stage-type.enum';
import { WorkflowMessageModel } from './workflow-message.model';
import { WorkflowStepModel } from './workflow-step.model';

export class WorkflowStageModel {
    ObjectID: string;
    ObjectClass = CLASSES.WORKFLOW_STAGE;
    Name: string;
    UseMessaging: boolean;
    StageType: StageTypeEnum;
    SortOrder: number;
    AutoProgress: boolean;
    WorkFlowTemplate: string; // ID of WorkflowTemplateModel
    WorkFlowMessages: Array<WorkflowMessageModel>;
    Steps: Array<WorkflowStepModel>;

    constructor(name: string, useMsg: boolean, stage: StageTypeEnum, order: number, autoProgress: boolean,
                templateID: string) {
        this.Name = name;
        this.UseMessaging = useMsg;
        this.StageType = stage;
        this.SortOrder = order;
        this.AutoProgress = autoProgress;
        this.WorkFlowTemplate = templateID;
        this.Steps = [];
        this.WorkFlowMessages = [];
    }
}
