import { Component, OnDestroy, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';
import { MyCareerUser } from './my-career-users.model';
import { MyCareerUsersService } from './my-career-users.service';

@Component({
    selector: 'app-my-career-users',
    templateUrl: './my-career-users.component.html'
})
export class MyCareerUsersComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    myCareerUser : MyCareerUser = new MyCareerUser();
    careerUsers: any[] = [];
    showResults: boolean = false;
    careerUsersCols = [
        { field: 'FirstName', header: 'First Name', width: '20%', noSort: false, noFilter: false},
        { field: 'LastName', header: 'Last Name', width: '20%', noSort: false, noFilter: false},
        { field: 'Email', header: 'Email', width: '20%', noSort: false, noFilter: false},
        { field: 'Mobile', header: 'Mobile', width: '20%', noSort: false, noFilter: false},
        { field: 'Active', header: 'Active', width: '5%', noSort: false, noFilter: false},
        { field: '', header: '', width: '11%', noSort: true, noFilter: true},
        { field: '', header: '', width: '4%', noSort: true, noFilter: true}
    ];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private myCareerUsersService: MyCareerUsersService
    ){
        
    }

    ngOnInit() {
        this.searchService.getLastSearchRequest("CareerProfiles").subscribe(
            data => {
                if (data != null) {
                    this.myCareerUser = data.queryParams;
                    this.getCareerUsers(false);
                }
            }
        );
    }
    

    getCareerUsers(saveSearch: boolean) {
        
        this.showResults    =   true;
        this.showLoader     =   true;
        let assocs          =   ['Candidate', 'Candidate.User'];
        
        this.subscriptions.push(this.myCareerUsersService.getCareerUsers(this.myCareerUser, assocs, saveSearch)
            .subscribe(
                data => {
                    this.careerUsers = data;
                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    loginAsUser(user: any) {
        this.showLoader = true;
        const params = {
            User: user.ObjectID
        };
        
        this.utilsService.processObjects('AssumeMCUser', params).subscribe(
            () => {
                this.showLoader = false;
            },
            err => {
                this.utilsService.handleError(err);
                this.showLoader = false;
            }
        );
    }

    onClear() {
        this.myCareerUser = new MyCareerUser();
        this.careerUsers = [];
    }
        
    onRowSelect(data) {
        this.router.navigate(['/my-career/view-career-user', data.ObjectID]);
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}