import { Component } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { CareerProfileModel } from '../../models/career-profile.model';

@Component({
    selector: 'app-profile-tasks',
    templateUrl: './profile-tasks.component.html',
    styleUrls: ['./profile-tasks.component.scss']
})
export class ProfileTasksComponent extends BaseComponent {

    careerProfile = new CareerProfileModel();
    avatarBorder = 'linear-gradient(90deg, transparent 50%, #EAECEE 50%), linear-gradient(90deg, #EAECEE 50%, transparent 50%)';
    backgroundColor = '#1469A2';

    constructor(
        private ps: PersonalDetailsService,
        private us: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.ps.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(profile => {
                this.careerProfile = this.us.cloneObject(profile);
                this.setProfileCompletion();
            });
    }

    setProfileCompletion(): void {
        // const percentage =  (this.careerProfile.CompletedPercentage || 0) * 3.6;
        // for (let i = 0; i <= percentage; i++) {
        //     if (percentage === 360) {
        //         this.backgroundColor = '#1DBA3C';
        //         this.avatarBorder = `linear-gradient(${90 + percentage}deg, transparent 50%, #1DBA3C 50%),linear-gradient(90deg, #1DBA3C 50%, transparent 50%)`;
        //     } else if (percentage<=180){
        //         this.avatarBorder = `linear-gradient(${90 + percentage}deg, transparent 50%, #EAECEE 50%),linear-gradient(90deg, #EAECEE 50%, transparent 50%)`;
        //     } else {
        //         this.avatarBorder = `linear-gradient(${percentage - 90}deg, transparent 50%, #1469A2 50%),linear-gradient(90deg, #EAECEE 50%, transparent 50%)`;
        //     }
        // }
    }

}
