import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { IntroLetterService } from '../../services/intro-letter.service';
import { takeUntil } from 'rxjs/operators';
import { IntroductionLetterModel } from '../../models/introduction-letter.model';
import { UtilsService } from '../../../oneit/services/utils.service';

@Component({
    selector: 'app-intro-letters',
    templateUrl: './intro-letters.component.html',
    styleUrls: ['./intro-letters.component.scss']
})
export class IntroLettersComponent extends BaseComponent implements OnInit {

    introLetters: IntroductionLetterModel[] = [];

    constructor(
        private introLetterService: IntroLetterService,
        private utilService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getIntroLetters();
    }

    getIntroLetters(): void {
        this.isLoading = true;
        this.introLetterService.getIntroLetters()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.introLetters = response;
            }, err => {
                this.isLoading = false;
                this.utilService.handleError(err);
        })
    }


}
