<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    HiringTeam  hiringTeam      =   (HiringTeam) process.getAttribute("HiringTeam");

    Debug.assertion(hiringTeam != null , "Invalid hiringTeam in admin portal my hiring team invoices");

    String          nextPage    =   WebUtils.getSamePageInRenderMode(request, "Page");
    List<Invoice>   invoices    =   StripeUtils.retrieveInvoices(hiringTeam);
%>

    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                    <h1 class="page-title page-title-with-arrow">
                        <oneit:button   cssClass="arrow-btn-blue"  name="gotoPage" value=" " skin="link"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("cancelProcess", true)
                                                                            .toMap() %>" >
                            <img src="images/arrow-left-prev_blue.svg" />
                        </oneit:button>
                        <%= hiringTeam.getHiringTeamName() %>
                    </h1>
                    <div class="my-company-area">
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>

                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="4"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="company-detail">
                                    <div class="tabpage-title">
                                        <label class="label-20">Invoices</label><br/>               
                                    </div>
                                </div>
                                <%
                                    if(hiringTeam.hasBillingSetup())
                                    {
                                %>
                                        <div class="billing-notice">
                                            If you need to change your Billing Method or the Plan you are on, please <a href=" https://www.talentology.com/support/" target="_blank">contact us.</a>
                                        </div>
                                <%
                                    }
                                %>
                                <div class="">
                                    <div class="a-label-row">
                                        <div class="col-md-2 col-sm-2 col-xs-2 inv-hdr text-left">Date</div>
                                        <div class="col-md-6 col-sm-6 col-xs-6 inv-hdr text-left">Item</div>
                                        <div class="col-md-2 col-sm-2 col-xs-2 inv-hdr text-right">Charge</div>
                                        <div class="col-md-2 col-sm-2 col-xs-2 inv-hdr text-right">Export</div>
                                    </div>
                                    
                                    <div class="line-break"></div>
                                    
                                    <%
                                        for(Invoice invoice : invoices)
                                        {
                                    %>
                                            <div class="a-label-row">
                                                <div class="col-md-2 col-sm-2 col-xs-2 text-left inv-det">
                                                    <oneit:toString value="<%= new Date(invoice.getDate() * 1000) %>"  mode="MidDate"/>
                                                </div>
                                                <div class="col-md-6 col-sm-6 col-xs-6 text-left inv-des">
                                                    Subscription <%= StringUtils.subNulls(invoice.getDescription(), "") %>
                                                    <!--<div class="inv-det">#12536536</div>-->
                                                </div>
                                                <div class="col-md-2 col-sm-2 col-xs-2 text-right inv-amt">
                                                    <oneit:toString value="<%= invoice.getAmountDue() * 0.01 %>"  mode="Currency"/>
                                                </div>
                                                <div class="col-md-2 col-sm-2 col-xs-2 text-right inv-det">
                                                    <a href="<%= invoice.getInvoicePdf() %>">
                                                        <span class=""><img src="images/pdf.svg" class="inv-pdf"/><span>
                                                        &nbsp;
                                                        PDF
                                                    </a>
                                                </div>
                                            </div>
                                            
                                            <div class="line-break"></div>
                                    <%
                                        }
                                    %>
                                </div>
                            </div>
                        </div>
                    </div>
                </oneit:form>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
