<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<%
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "applications");
    String                  currentPage     =   (String) getData(request, "currentPage");
    ApplicationStatus       appStatus       =   (ApplicationStatus)  getData(request, "WorkFlowStatus");
    String                  applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
%>

<oneit:dynIncluded>
    <script type="text/javascript">
        $(document).ready(function() 
        {            
            $("[name$='WorkFlow']").change(function()
            {
                var id  = $(this).closest('.appli-row').attr('id');
                $('.save-application' + id).click();
            });
        });
    </script>
    <div class="view-appli-list">
    <%
        int j   = 0;

        for(JobApplication jobApplication : applications)
        {
            long        criteriaVal =   jobApplication.getRequirementFitScore(); 
            String      roleFit     =   FormatUtils.stringify(jobApplication.getCandidate().roleFitCompletedPercentage(job), "PercentageTwoDP", "0");
            String      culture     =   FormatUtils.stringify(jobApplication.getCandidate().cultureCompletedPercentage(job), "PercentageWholeNumber", "0");
            String      criteria    =   FormatUtils.stringify(jobApplication.getRequirementFitScore(), "PercentageWholeNumber", "0");
            String      appID       =   "app-id-" + jobApplication.getID().toString();
            Integer     overallRank =   jobApplication.getOverallRank();
            Boolean     isTopRank   =   CollectionUtils.equals(overallRank, 1);
            WorkFlow    workflow    =   job.getWorkFlowByStatus(jobApplication.getApplicationStatus());
            boolean     missingReq  =   jobApplication.hasFailedEssentialRequirements();
            
            jobApplication.setWorkFlow(workflow);
    %>
            <div class="appli-row"  id="<%= jobApplication.getID() %>">
                <div class="appli-checkbox appli-l eq-second-height">
                    <div class="checkbox-list">
                        <input type="checkbox"  name="IsSelected" value="<%= jobApplication.getObjectID().toString() %>"  id="<%= appID %>" class="applicant" >
                        <label for="<%= appID %>"></label>
                    </div>
                </div>
                <div class="appli-list-name appli-l eq-second-height">
                    <oneit:button   value=" "    name="gotoPage" cssClass="<%= jobApplication.getID() + ""%>" skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).mapEntry("Applications", applications).toMap())
                                                                    .toMap() %>">
                        <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                        <div class="appli-int-status">
                            <a href="<%= "mailto:" + jobApplication.getCandidate().getUser().getUserName() %>">Email</a>
                            <oneit:toString value="<%= jobApplication.getCandidate().getPhone() %>"   mode="EscapeHTML" />
                        </div>
                    </oneit:button>
                </div>
                <%
                    String widthClass   =   "appli-jcs2";
                    
                    if(job.getIncludeAssessmentCriteria() == Boolean.TRUE)
                    {
                        widthClass  =   "appli-jcs";
                    }
                    
                    if(job.getIncludeAssessmentCriteria() == Boolean.TRUE)
                    {
                %>
                        <div class="<%= widthClass %> appli-l eq-second-height">
                            <span class="appli-view-bar">
                                <div class="progress">
                                    <div class="progress-bar <%= (criteriaVal == 100 && !missingReq ? " green" : "")%>" role="progressbar" aria-valuenow="<%= criteria %>" aria-valuemin="0" aria-valuemax="100" 
                                            style="<%= "width: " + criteria %>">
                                    </div>
                                </div>
                                    <span class="missing-requirements-icon" style="<%= missingReq ? "display:inline-block" : "display:none" %>"></span>
                            </span>
                            <span class="<%= missingReq ? "red-requirements" : "" %>">
                                requirements
                            </span>
                        </div>
                <%
                    }
                %>
                <div class="<%= widthClass %> appli-l eq-second-height">
                    <span class="appli-view-bar">
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" aria-valuenow="<%= culture %>" aria-valuemin="0" aria-valuemax="100" 
                                    style="<%= "width: " + culture %>">
                            </div>                                
                        </div>
                    </span>
                    culture fit
                </div>
                <div class="<%= widthClass %> appli-l eq-second-height">
                    <span class="appli-view-bar">
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" aria-valuenow="<%= roleFit %>" aria-valuemin="0" aria-valuemax="100" 
                                    style="<%= "width: " + roleFit %>">
                            </div>
                        </div>
                    </span>
                    role fit
                </div>
                <div class="appli-status appli-l eq-second-height">
                    <div class="appli-list-drop">
                        <tagfile:ormsingleasso_select obj="<%= jobApplication %>"   assocName="WorkFlow"    cssClass="form-control app-process"    
                                                      options="<%= job.getWorkFlowsSet().toArray(new WorkFlow[0]) %>"/>
                    </div>
                </div> 
                <oneit:button   name="changeApplicationStatus"  value=" "   cssClass="<%= "save-application" +  jobApplication.getID().toString() + " hidden"%>"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("WorkFlowStatus", appStatus).mapEntry("Job", job).toMap())
                                                                    .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "WorkFlowStatus"})))
                                                                    .mapEntry("JobApplication", jobApplication)
                                                                    .toMap() %>" />
            </div>
    <%
            j++;
        }
    %>
    </div>
</oneit:dynIncluded>
