<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "signin_jsp"; } %>
<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();  
    String              nextPage    =   WebUtils.getArticleByShortCut(objTran, WebUtils.ADMIN_HOME).getLink(request);
%>
<html lang="en">
    <head>
        <meta charset="utf-8"></meta>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"></meta>
        <meta name="viewport" content="width=device-width, initial-scale=1"></meta>
        <title>Talentology</title>
                
        <%@include file="/inc/std_imports.jsp" %>
    </head>
    
    <body class="bg-color">
        <script type="text/javascript">
            var interval;
            
            $(document).ready(function() {
                validate();
                $('input').on('change keyup', function() { validate() });
                interval =  setInterval(function() { validate(); }, 500);
            });
            
            function validate() {
                var empty = false;
                $('input[required]').each(function() {
                    if ($( this ).val() == '') {
                        empty = true;
                        if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                           empty = false;
                        }
                    }
                });

                if (empty) {
                    $('.login-btn').attr('disabled', 'disabled');
                } else {
                    $('.login-btn').removeAttr('disabled');
                     clearInterval(interval);
                }
            }
        </script>
        <style>
            button[disabled] {
                opacity: 0.6;
                background-color: #0582ba;
            }
        </style>
        <div class="container">
            <div class="row">    
                <div class="main-verify-identity">
                    <div class="login-logo"><img src="<%= request.getContextPath() %>/images/logo.svg" /></div>
                        <div class="main-box-layout login-box">
                            <oneit:form name="login"    method="post">
                                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                            
                                <div class="form-group text-left">
                                    <label>Email Address</label>
                                    <input type="text"  class="form-control"        name="username" required>
                                </div>
                                <div class="form-group text-left">
                                    <label>Password</label>
                                    <input type="password"  class="form-control"    name="password" required>
                                </div>
                                <div class="form-group">

                                    <oneit:button   value="Forgot password?"    name="gotoPage"    cssClass="forgot-pass"  skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "forgot_password.jsp")
                                                                                    .toMap() %>"></oneit:button>
                                    <oneit:button   value="Sign in"   name="login"    cssClass="box-btn login-btn"
                                                    requestAttribs="<%= CollectionUtils.EMPTY_MAP%>"/>
                                </div>
                            </oneit:form>
                            <div class="box-br-line"><span></span></div>
                            <div class="box-label">Sign in using your social network of choice</div>
                            
                            <oneit:form name="socialLogin" method="post">
                                <ul class="social-login">
                                    <li>
                                        <oneit:button   value=" "  name="linkedinOAuthLogin"   skin="link"  cssClass="social_login_btn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", nextPage).toMap() %>">
                                            <img src="<%= request.getContextPath() %>/images/login-linkedin-icon.svg" />
                                        </oneit:button>
                                    </li>
                                    <li>
                                        <oneit:button   value=" "  name="facebookOAuthLogin"   skin="link"  cssClass="social_login_btn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", nextPage).toMap() %>">
                                            <img src="<%= request.getContextPath() %>/images/login-facebok-icon.svg" />
                                        </oneit:button>
                                    </li>
                                    <li>
                                        <oneit:button   value=" "  name="googleOAuthLogin"     skin="link"  cssClass="social_login_btn"
                                                        requestAttribs="<%= CollectionUtils.mapEntry ("nextPage", nextPage).toMap() %>">
                                            <img src="<%= request.getContextPath() %>/images/login-google.png" />
                                        </oneit:button>
                                    </li>
                                </ul>                    
                            </oneit:form>
                        </div>
                    <footer class="power-footer">        
                        <div class="footer-link text-center">
                            <ul>
                                <li><a href="#">&COPY; <%= Calendar.getInstance().get(Calendar.YEAR) %> Talentology</a></li>
                                <li><a href="#">Privacy Policy</a></li>
                            </ul>
                        </div>
                    </footer>  
                </div>
            </div>
        </div>
    </body>
</html>