<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "forgot_password_jsp"; } %>

<html lang="en">
    <head>
        <meta charset="utf-8"></meta>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"></meta>
        <meta name="viewport" content="width=device-width, initial-scale=1"></meta>
        <title>Talentology</title>
                
        <%@include file="/inc/std_imports.jsp" %>
    </head>
    
    <body class="bg-color">
        <script type="text/javascript">
            $(document).ready(function() {
                validate();
                $('input').on('change keyup', function() { validate() });
            });
            
            function validate() {
                var empty = false;
                $('input[required]').each(function() {
                    if ( $.trim($( this ).val()) == '') {
                        empty = true;
                        if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                           empty = false;
                        }
                    }
                });

                if (empty) {
                    $('.send-btn').attr('disabled', 'disabled');
                } else {
                    $('.send-btn').removeAttr('disabled');
                }
            }
        </script>
        <style>
            button[disabled] {
                opacity: 0.6;
                background-color: #0582ba;
            }
        </style>
        <div class="container">
            <div class="row">    
                <div class="main-verify-identity">
                    <div class="login-logo"><img src="<%= request.getContextPath() %>/images/logo.svg" /></div>
                    <oneit:form name="forgotPassword"    method="post">
                        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        <div class="main-box-layout login-box">
                            <div class="text-left">
                                <p >
                                    Enter your email address below. If we find a matching account, then you'll receive an email with a password reset link.
                                </p>
                            </div>
                            <div>&nbsp;</div>
                            <div class="form-group text-left">
                                <label>Email Address</label>
                                <input type="email"  class="form-control"   name="email"    required>
                            </div>

                            <div class="form-group">
                                <oneit:button   value="Send"    name="forgotPassword"   cssClass="box-btn send-btn"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "sign_in.jsp?sent=true")
                                                                                .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "resetPasswordEmailSent")
                                                                                .toMap() %>"/>
                            </div>
                        </div>
                    </oneit:form>
                </div>
            </div>
        </div>
    </body>
</html>