package performa.orm;

import oneit.logging.LoggingArea;
import oneit.objstore.ObjectStatus;
import oneit.objstore.ValidationContext;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.rdbms.filters.IsNotNullFilter;
import oneit.security.SecUser;
import oneit.utils.CollectionUtils;
import oneit.utils.StringUtils;
import oneit.utils.parsers.FieldException;


public class Company extends BaseCompany
{
    private static final long serialVersionUID = 0L;
    
    public  static LoggingArea  LOG = LoggingArea.createLoggingArea("Company");

    // This constructor should not be called
    public Company ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    
    public boolean showHasClientSupport()
    {
        return isTrue(getHasClientSupport());
    }
    
    //This logic moved from invite_users.jsp
    public boolean createDefaultUser() throws FieldException
    {
        boolean addUser =   true;
        for (CompanyUser cUser : getUsersSet())
        {
            if(!CollectionUtils.equals(cUser, getAddedByUser()))
            {
                addUser =   false;
            }
        }
        
        if(addUser)
        {
            SecUser     secUser     =   SecUser.createSecUser(getTransaction());
            CompanyUser companyUser =   secUser.getExtensionOrCreate(CompanyUser.REFERENCE_CompanyUser);
        
            addToUsers(companyUser);
        }
        return addUser;
    }

    
    @Override
    public void validate(ValidationContext context) 
    {
        if(getStatus() != ObjectStatus.NEW)
        {
            context.check(getHiringTeamType() != null , this, FIELD_HiringTeamType, "mandatory");
        }
        
        super.validate(context);
    }
    
    
    public Boolean isEmailCorrect()
    {
        return StringUtils.isEmailAddress(StringUtils.subBlanks(getUserEmail()));
    }
    
    
    @Override
    public String getToString() 
    {
        return StringUtils.subNulls(getCompanyName(), super.getToString());
    }
    
    
    public PaymentPlan getSelectedPaymentPlan()
    {
        if(getPaymentJobCount()!=null)
        {
            PaymentPlan[]   plans   =   PaymentPlan.SearchByAll()
                                                .andActiveJobCount(new EqualsFilter<>(getPaymentJobCount()))
                                                .search(getTransaction());
            
            if(plans.length>0)
            {
                return plans[0];
            }
        }
        
        return null;
    }
    
    
    public Double getPaymentPlanAmount()
    {
        if(getSelectedPaymentPlan()!=null)
        {
            return getSelectedPaymentPlan().getAmount();
        }
        
        return null;
    }
}