/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.AccountCollection;
import com.stripe.model.AccountDeclineChargeOn;
import com.stripe.model.AccountTosAcceptance;
import com.stripe.model.AccountTransferSchedule;
import com.stripe.model.DeletedAccount;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.LegalEntity;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Account
extends APIResource
implements HasId,
MetadataStore<Account> {
    String id;
    String object;
    String businessLogo;
    String businessName;
    String businessPrimaryColor;
    @SerializedName(value="business_url")
    String businessURL;
    Boolean chargesEnabled;
    String country;
    Boolean debitNegativeBalances;
    AccountDeclineChargeOn declineChargeOn;
    String defaultCurrency;
    Boolean detailsSubmitted;
    String displayName;
    String email;
    ExternalAccountCollection externalAccounts;
    Keys keys;
    LegalEntity legalEntity;
    Boolean managed;
    Map<String, String> metadata;
    String productDescription;
    String statementDescriptor;
    String supportEmail;
    String supportPhone;
    @SerializedName(value="support_url")
    String supportURL;
    String timezone;
    AccountTosAcceptance tosAcceptance;
    AccountTransferSchedule transferSchedule;
    Boolean transfersEnabled;
    Verification verification;
    @Deprecated
    List<String> currenciesSupported;

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getBusinessLogo() {
        return this.businessLogo;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getBusinessPrimaryColor() {
        return this.businessPrimaryColor;
    }

    public void setBusinessPrimaryColor(String businessPrimaryColor) {
        this.businessPrimaryColor = businessPrimaryColor;
    }

    public String getBusinessURL() {
        return this.businessURL;
    }

    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    public String getCountry() {
        return this.country;
    }

    public Boolean getDebitNegativeBalances() {
        return this.debitNegativeBalances;
    }

    public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
        this.debitNegativeBalances = debitNegativeBalances;
    }

    public AccountDeclineChargeOn getDeclineChargeOn() {
        return this.declineChargeOn;
    }

    public void setDeclineChargeOn(AccountDeclineChargeOn declineChargeOn) {
        this.declineChargeOn = declineChargeOn;
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    public Keys getKeys() {
        return this.keys;
    }

    public LegalEntity getLegalEntity() {
        return this.legalEntity;
    }

    public Boolean getManaged() {
        return this.managed;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public String getSupportEmail() {
        return this.supportEmail;
    }

    public String getSupportPhone() {
        return this.supportPhone;
    }

    public String getSupportURL() {
        return this.supportURL;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public AccountTosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    public void setTosAcceptance(AccountTosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    public AccountTransferSchedule getTransferSchedule() {
        return this.transferSchedule;
    }

    public void setTransferSchedule(AccountTransferSchedule transferSchedule) {
        this.transferSchedule = transferSchedule;
    }

    public Boolean getTransfersEnabled() {
        return this.transfersEnabled;
    }

    public Verification getVerification() {
        return this.verification;
    }

    @Deprecated
    public List<String> getCurrenciesSupported() {
        return this.currenciesSupported;
    }

    public static Account create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.create(params, null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.classURL(Account.class), params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.requestCollection(Account.classURL(Account.class), params, AccountCollection.class, options);
    }

    @Deprecated
    public static AccountCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, null);
    }

    @Deprecated
    public static AccountCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, options);
    }

    public static Account retrieve() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.retrieve((RequestOptions)null);
    }

    @Deprecated
    public static Account retrieve(String apiKeyOrAccountId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
            return Account.retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
        }
        return Account.retrieve(apiKeyOrAccountId, null);
    }

    public static Account retrieve(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.singleClassURL(Account.class), null, Account.class, options);
    }

    public static Account retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.instanceURL(Account.class, id), null, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account reject(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.instanceURL(Account.class, this.id) + "/reject", params, Account.class, null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.instanceURL(Account.class, this.id), params, Account.class, options);
    }

    public DeletedAccount delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    public DeletedAccount delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null, null);
    }

    public DeletedAccount delete(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(params, null);
    }

    public DeletedAccount delete(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.DELETE, Account.instanceURL(Account.class, this.id), params, DeletedAccount.class, options);
    }

    public static class Keys
    extends StripeObject {
        String publishable;
        String secret;

        public String getPublishable() {
            return this.publishable;
        }

        public String getSecret() {
            return this.secret;
        }
    }

    public static class Verification
    extends StripeObject {
        Boolean contacted;
        String disabledReason;
        Long dueBy;
        List<String> fieldsNeeded;

        public Boolean getContacted() {
            return this.contacted;
        }

        public String getDisabledReason() {
            return this.disabledReason;
        }

        public Long getDueBy() {
            return this.dueBy;
        }

        public List<String> getFieldsNeeded() {
            return this.fieldsNeeded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Verification ve = (Verification)o;
            return Verification.equals(this.contacted, ve.contacted) && Verification.equals(this.disabledReason, ve.disabledReason) && Verification.equals(this.dueBy, ve.dueBy) && Verification.equals(this.fieldsNeeded, ve.fieldsNeeded);
        }
    }
}

