package performa.form;

import com.stripe.Stripe;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.CurrencyPlanNPO;
import performa.orm.HiringTeam;
import performa.orm.StripePlanNPO;
import performa.utils.StripeUtils;


public class CreatePlanFP   extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        StripePlanNPO   plan    =   (StripePlanNPO) process.getAttribute("StripePlanNPO");

        LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1, "Inside CreatePlanFP for creating plan : ", plan);
        
        Stripe.apiKey = StripeUtils.STRIPE_KEY;

        for(CurrencyPlanNPO currencyPlan : plan.getCurrencyPlansSet())
        {
            StripeUtils.createPlan(plan, currencyPlan);
        }
        
        process.setAttribute("StripePlanNPO", null);
        
        return RedisplayResult.getInstance();
    }
}