/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BankAccount;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.TransferCollection;
import com.stripe.model.TransferReversalCollection;
import com.stripe.model.TransferTransactionCollection;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Transfer
extends ApiResource
implements MetadataStore<Transfer>,
HasId {
    String id;
    String object;
    Long amount;
    Long amountReversed;
    String applicationFee;
    ExpandableField<BalanceTransaction> balanceTransaction;
    BankAccount bankAccount;
    Long created;
    String currency;
    Long date;
    String description;
    ExpandableField<Account> destination;
    ExpandableField<Charge> destinationPayment;
    String failureCode;
    String failureMessage;
    Boolean livemode;
    Map<String, String> metadata;
    TransferReversalCollection reversals;
    Boolean reversed;
    ExpandableField<Charge> sourceTransaction;
    String sourceType;
    String statementDescriptor;
    String status;
    String transferGroup;
    String type;
    @Deprecated
    BankAccount account;
    @Deprecated
    List<String> otherTransfers;
    @Deprecated
    String recipient;
    @Deprecated
    String statementDescription;
    @Deprecated
    Summary summary;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String balanceTransactionId) {
        this.balanceTransaction = Transfer.setExpandableFieldId(balanceTransactionId, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction c) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String destinationId) {
        this.destination = ApiResource.setExpandableFieldId(destinationId, this.destination);
    }

    public Account getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account c) {
        this.destination = new ExpandableField<Account>(c.getId(), c);
    }

    public String getDestinationPayment() {
        return this.destinationPayment != null ? this.destinationPayment.getId() : null;
    }

    public void setDestinationPayment(String destinationPaymentId) {
        this.destinationPayment = Transfer.setExpandableFieldId(destinationPaymentId, this.destinationPayment);
    }

    public Charge getDestinationPaymentObject() {
        return this.destinationPayment != null ? this.destinationPayment.getExpanded() : null;
    }

    public void setDestinationPaymentObject(Charge destinationPayment) {
        this.destinationPayment = new ExpandableField<Charge>(destinationPayment.getId(), destinationPayment);
    }

    public TransferReversalCollection getReversals() {
        if (this.reversals.getUrl() == null) {
            this.reversals.setUrl(String.format("/v1/transfers/%s/reversals", this.getId()));
        }
        return this.reversals;
    }

    public String getSourceTransaction() {
        return this.sourceTransaction != null ? this.sourceTransaction.getId() : null;
    }

    public void setSourceTransaction(String sourceTransactionId) {
        this.sourceTransaction = Transfer.setExpandableFieldId(sourceTransactionId, this.sourceTransaction);
    }

    public Charge getSourceTransactionObject() {
        return this.sourceTransaction != null ? this.sourceTransaction.getExpanded() : null;
    }

    public void setSourceTransactionObject(Charge sourceTransaction) {
        this.sourceTransaction = new ExpandableField<Charge>(sourceTransaction.getId(), sourceTransaction);
    }

    @Deprecated
    public Transfer cancel() throws StripeException {
        return this.cancel(null);
    }

    @Deprecated
    public Transfer cancel(RequestOptions options) throws StripeException {
        return Transfer.request(ApiResource.RequestMethod.POST, Transfer.instanceUrl(Transfer.class, this.id) + "/cancel", null, Transfer.class, options);
    }

    public static Transfer create(Map<String, Object> params) throws StripeException {
        return Transfer.create(params, null);
    }

    public static Transfer create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Transfer.request(ApiResource.RequestMethod.POST, Transfer.classUrl(Transfer.class), params, Transfer.class, options);
    }

    public static TransferCollection list(Map<String, Object> params) throws StripeException {
        return Transfer.list(params, null);
    }

    public static TransferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Transfer.requestCollection(Transfer.classUrl(Transfer.class), params, TransferCollection.class, options);
    }

    public static Transfer retrieve(String id) throws StripeException {
        return Transfer.retrieve(id, null);
    }

    public static Transfer retrieve(String id, RequestOptions options) throws StripeException {
        return Transfer.retrieve(id, null, options);
    }

    public static Transfer retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Transfer.request(ApiResource.RequestMethod.GET, Transfer.instanceUrl(Transfer.class, id), params, Transfer.class, options);
    }

    @Deprecated
    public TransferTransactionCollection transactions(Map<String, Object> params) throws StripeException {
        return this.transactions(params, null);
    }

    @Deprecated
    public TransferTransactionCollection transactions(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Transfer.instanceUrl(Transfer.class, this.getId()), "/transactions");
        return Transfer.requestCollection(url, params, TransferTransactionCollection.class, options);
    }

    public Transfer update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Transfer update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Transfer.request(ApiResource.RequestMethod.POST, Transfer.instanceUrl(Transfer.class, this.id), params, Transfer.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountReversed() {
        return this.amountReversed;
    }

    @Generated
    public String getApplicationFee() {
        return this.applicationFee;
    }

    @Generated
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Boolean getReversed() {
        return this.reversed;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Deprecated
    @Generated
    public BankAccount getAccount() {
        return this.account;
    }

    @Deprecated
    @Generated
    public List<String> getOtherTransfers() {
        return this.otherTransfers;
    }

    @Deprecated
    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Deprecated
    @Generated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Deprecated
    @Generated
    public Summary getSummary() {
        return this.summary;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountReversed(Long amountReversed) {
        this.amountReversed = amountReversed;
    }

    @Generated
    public void setApplicationFee(String applicationFee) {
        this.applicationFee = applicationFee;
    }

    @Generated
    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setReversals(TransferReversalCollection reversals) {
        this.reversals = reversals;
    }

    @Generated
    public void setReversed(Boolean reversed) {
        this.reversed = reversed;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    @Generated
    public void setAccount(BankAccount account) {
        this.account = account;
    }

    @Deprecated
    @Generated
    public void setOtherTransfers(List<String> otherTransfers) {
        this.otherTransfers = otherTransfers;
    }

    @Deprecated
    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Deprecated
    @Generated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    @Deprecated
    @Generated
    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transfer)) {
            return false;
        }
        Transfer other = (Transfer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountReversed = this.getAmountReversed();
        Long other$amountReversed = other.getAmountReversed();
        if (this$amountReversed == null ? other$amountReversed != null : !((Object)this$amountReversed).equals(other$amountReversed)) {
            return false;
        }
        String this$applicationFee = this.getApplicationFee();
        String other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        BankAccount this$bankAccount = this.getBankAccount();
        BankAccount other$bankAccount = other.getBankAccount();
        if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$destinationPayment = this.getDestinationPayment();
        String other$destinationPayment = other.getDestinationPayment();
        if (this$destinationPayment == null ? other$destinationPayment != null : !this$destinationPayment.equals(other$destinationPayment)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        TransferReversalCollection this$reversals = this.getReversals();
        TransferReversalCollection other$reversals = other.getReversals();
        if (this$reversals == null ? other$reversals != null : !((Object)this$reversals).equals(other$reversals)) {
            return false;
        }
        Boolean this$reversed = this.getReversed();
        Boolean other$reversed = other.getReversed();
        if (this$reversed == null ? other$reversed != null : !((Object)this$reversed).equals(other$reversed)) {
            return false;
        }
        String this$sourceTransaction = this.getSourceTransaction();
        String other$sourceTransaction = other.getSourceTransaction();
        if (this$sourceTransaction == null ? other$sourceTransaction != null : !this$sourceTransaction.equals(other$sourceTransaction)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BankAccount this$account = this.getAccount();
        BankAccount other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        List<String> this$otherTransfers = this.getOtherTransfers();
        List<String> other$otherTransfers = other.getOtherTransfers();
        if (this$otherTransfers == null ? other$otherTransfers != null : !((Object)this$otherTransfers).equals(other$otherTransfers)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$statementDescription = this.getStatementDescription();
        String other$statementDescription = other.getStatementDescription();
        if (this$statementDescription == null ? other$statementDescription != null : !this$statementDescription.equals(other$statementDescription)) {
            return false;
        }
        Summary this$summary = this.getSummary();
        Summary other$summary = other.getSummary();
        return !(this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transfer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountReversed = this.getAmountReversed();
        result = result * 59 + ($amountReversed == null ? 43 : ((Object)$amountReversed).hashCode());
        String $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : $applicationFee.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        BankAccount $bankAccount = this.getBankAccount();
        result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $destinationPayment = this.getDestinationPayment();
        result = result * 59 + ($destinationPayment == null ? 43 : $destinationPayment.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        TransferReversalCollection $reversals = this.getReversals();
        result = result * 59 + ($reversals == null ? 43 : ((Object)$reversals).hashCode());
        Boolean $reversed = this.getReversed();
        result = result * 59 + ($reversed == null ? 43 : ((Object)$reversed).hashCode());
        String $sourceTransaction = this.getSourceTransaction();
        result = result * 59 + ($sourceTransaction == null ? 43 : $sourceTransaction.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BankAccount $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        List<String> $otherTransfers = this.getOtherTransfers();
        result = result * 59 + ($otherTransfers == null ? 43 : ((Object)$otherTransfers).hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $statementDescription = this.getStatementDescription();
        result = result * 59 + ($statementDescription == null ? 43 : $statementDescription.hashCode());
        Summary $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Summary
    extends StripeObject {
        Long adjustmentCount;
        Long adjustmentGross;
        Long chargeCount;
        Long chargeFees;
        Long chargeGross;
        Long net;
        Long refundCount;
        Long refundFees;
        Long refundGross;
        Long validationCount;
        Long validationFees;

        @Generated
        public Long getAdjustmentCount() {
            return this.adjustmentCount;
        }

        @Generated
        public Long getAdjustmentGross() {
            return this.adjustmentGross;
        }

        @Generated
        public Long getChargeCount() {
            return this.chargeCount;
        }

        @Generated
        public Long getChargeFees() {
            return this.chargeFees;
        }

        @Generated
        public Long getChargeGross() {
            return this.chargeGross;
        }

        @Generated
        public Long getNet() {
            return this.net;
        }

        @Generated
        public Long getRefundCount() {
            return this.refundCount;
        }

        @Generated
        public Long getRefundFees() {
            return this.refundFees;
        }

        @Generated
        public Long getRefundGross() {
            return this.refundGross;
        }

        @Generated
        public Long getValidationCount() {
            return this.validationCount;
        }

        @Generated
        public Long getValidationFees() {
            return this.validationFees;
        }

        @Generated
        public void setAdjustmentCount(Long adjustmentCount) {
            this.adjustmentCount = adjustmentCount;
        }

        @Generated
        public void setAdjustmentGross(Long adjustmentGross) {
            this.adjustmentGross = adjustmentGross;
        }

        @Generated
        public void setChargeCount(Long chargeCount) {
            this.chargeCount = chargeCount;
        }

        @Generated
        public void setChargeFees(Long chargeFees) {
            this.chargeFees = chargeFees;
        }

        @Generated
        public void setChargeGross(Long chargeGross) {
            this.chargeGross = chargeGross;
        }

        @Generated
        public void setNet(Long net) {
            this.net = net;
        }

        @Generated
        public void setRefundCount(Long refundCount) {
            this.refundCount = refundCount;
        }

        @Generated
        public void setRefundFees(Long refundFees) {
            this.refundFees = refundFees;
        }

        @Generated
        public void setRefundGross(Long refundGross) {
            this.refundGross = refundGross;
        }

        @Generated
        public void setValidationCount(Long validationCount) {
            this.validationCount = validationCount;
        }

        @Generated
        public void setValidationFees(Long validationFees) {
            this.validationFees = validationFees;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Summary)) {
                return false;
            }
            Summary other = (Summary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$adjustmentCount = this.getAdjustmentCount();
            Long other$adjustmentCount = other.getAdjustmentCount();
            if (this$adjustmentCount == null ? other$adjustmentCount != null : !((Object)this$adjustmentCount).equals(other$adjustmentCount)) {
                return false;
            }
            Long this$adjustmentGross = this.getAdjustmentGross();
            Long other$adjustmentGross = other.getAdjustmentGross();
            if (this$adjustmentGross == null ? other$adjustmentGross != null : !((Object)this$adjustmentGross).equals(other$adjustmentGross)) {
                return false;
            }
            Long this$chargeCount = this.getChargeCount();
            Long other$chargeCount = other.getChargeCount();
            if (this$chargeCount == null ? other$chargeCount != null : !((Object)this$chargeCount).equals(other$chargeCount)) {
                return false;
            }
            Long this$chargeFees = this.getChargeFees();
            Long other$chargeFees = other.getChargeFees();
            if (this$chargeFees == null ? other$chargeFees != null : !((Object)this$chargeFees).equals(other$chargeFees)) {
                return false;
            }
            Long this$chargeGross = this.getChargeGross();
            Long other$chargeGross = other.getChargeGross();
            if (this$chargeGross == null ? other$chargeGross != null : !((Object)this$chargeGross).equals(other$chargeGross)) {
                return false;
            }
            Long this$net = this.getNet();
            Long other$net = other.getNet();
            if (this$net == null ? other$net != null : !((Object)this$net).equals(other$net)) {
                return false;
            }
            Long this$refundCount = this.getRefundCount();
            Long other$refundCount = other.getRefundCount();
            if (this$refundCount == null ? other$refundCount != null : !((Object)this$refundCount).equals(other$refundCount)) {
                return false;
            }
            Long this$refundFees = this.getRefundFees();
            Long other$refundFees = other.getRefundFees();
            if (this$refundFees == null ? other$refundFees != null : !((Object)this$refundFees).equals(other$refundFees)) {
                return false;
            }
            Long this$refundGross = this.getRefundGross();
            Long other$refundGross = other.getRefundGross();
            if (this$refundGross == null ? other$refundGross != null : !((Object)this$refundGross).equals(other$refundGross)) {
                return false;
            }
            Long this$validationCount = this.getValidationCount();
            Long other$validationCount = other.getValidationCount();
            if (this$validationCount == null ? other$validationCount != null : !((Object)this$validationCount).equals(other$validationCount)) {
                return false;
            }
            Long this$validationFees = this.getValidationFees();
            Long other$validationFees = other.getValidationFees();
            return !(this$validationFees == null ? other$validationFees != null : !((Object)this$validationFees).equals(other$validationFees));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Summary;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $adjustmentCount = this.getAdjustmentCount();
            result = result * 59 + ($adjustmentCount == null ? 43 : ((Object)$adjustmentCount).hashCode());
            Long $adjustmentGross = this.getAdjustmentGross();
            result = result * 59 + ($adjustmentGross == null ? 43 : ((Object)$adjustmentGross).hashCode());
            Long $chargeCount = this.getChargeCount();
            result = result * 59 + ($chargeCount == null ? 43 : ((Object)$chargeCount).hashCode());
            Long $chargeFees = this.getChargeFees();
            result = result * 59 + ($chargeFees == null ? 43 : ((Object)$chargeFees).hashCode());
            Long $chargeGross = this.getChargeGross();
            result = result * 59 + ($chargeGross == null ? 43 : ((Object)$chargeGross).hashCode());
            Long $net = this.getNet();
            result = result * 59 + ($net == null ? 43 : ((Object)$net).hashCode());
            Long $refundCount = this.getRefundCount();
            result = result * 59 + ($refundCount == null ? 43 : ((Object)$refundCount).hashCode());
            Long $refundFees = this.getRefundFees();
            result = result * 59 + ($refundFees == null ? 43 : ((Object)$refundFees).hashCode());
            Long $refundGross = this.getRefundGross();
            result = result * 59 + ($refundGross == null ? 43 : ((Object)$refundGross).hashCode());
            Long $validationCount = this.getValidationCount();
            result = result * 59 + ($validationCount == null ? 43 : ((Object)$validationCount).hashCode());
            Long $validationFees = this.getValidationFees();
            result = result * 59 + ($validationFees == null ? 43 : ((Object)$validationFees).hashCode());
            return result;
        }
    }
}

