<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<%
    Job                 job             =   (Job) process.getAttribute("Job");
    AppSortOption       appSortOpt      =   (AppSortOption) getData(request, "SortOption");
    ApplicationStatus   workflowStatus  =   (ApplicationStatus)  getData(request, "WorkFlowStatus"); 
    boolean             isDraft         =   workflowStatus == ApplicationStatus.DRAFT; 
    ApplicationFilter   appFilter       =   (ApplicationFilter)  getData(request, "ApplicationFilter"); 
    Boolean             showOrderBy     =   getData(request, "ShowOrderBy")!= null ? (Boolean)  getData(request, "ShowOrderBy") : Boolean.FALSE;
    boolean             showList        =   (boolean)  getData(request,"ShowList");
    SearchApplicant     searchApplicant =   (SearchApplicant)  getData(request, "SearchApplicant");
    String              applicantsPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS) + "&JobID=" + job.getID() + "&WorkFlowStatus=" +  workflowStatus.getName();
    List<WorkFlow>      sortedWorkFlows =   ObjstoreUtils.sort(job.getApplicantWFs(), 
                                                        new ObjectTransform[]{WorkFlow.pipesWorkFlow().toSortOrder()}, 
                                                        new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});
%>

<oneit:dynIncluded>
    <script type="text/javascript">
        $(document).ready(function() 
        {   
            $("[name$='AppStatusWorkFlow']").change(function()
            {
                $('.bulk-update').click();
            });
            
            enableBulkEdit();
             
            $(".applicant").change(function() {
                enableBulkEdit();
            });
            
            $("#select_all").on("click",function(){
              
                $('.checkbox-list input:checkbox').not(this).prop('checked', this.checked);
                enableBulkEdit();
            });
        });
        
        function enableBulkEdit() {
            var disable  =   <%= isDraft %> || $('input[class=applicant]:checked').length === 0;
            $("[name$='AppStatusWorkFlow']").prop("disabled", disable);
        }
        
       $(function(){
            $('.search-icon-btn').click(function () {   
               $('.search-real-btn').click();
            });
        });
    </script>
    <div class="main-applicants-filter">
        <div class="appli-list-shorting">
            <div class="shorting-dropdown appli-left">
                <span class="appli-order-label">Bulk Update</span>
                <div class="wider-select bullk-app-process">
                    <tagfile:ormsingleasso_select obj="<%= job %>"   assocName="AppStatusWorkFlow"  cssClass="form-control app-process" id="AppProcessOption"    
                                                          options="<%= sortedWorkFlows.toArray(new WorkFlow[0]) %>"/>
                </div>
                <oneit:button   name="bulkupdate"   value=" "   cssClass="bulk-update"  skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("WorkFlowStatus", workflowStatus).mapEntry("Job", job).toMap())
                                                                    .mapEntry ("attribNamesToRestore", new HashSet<String> (Arrays.asList(new String[] {"Job", "WorkFlowStatus"})))
                                                                    .mapEntry("Job", job)
                                                                    .toMap() %>" />
            </div> 
            <div class="appli-filter">
                <%
                    if(!CollectionUtils.equals(workflowStatus,ApplicationStatus.DRAFT))
                    {
                %>
                        <ul class="">
                            <li class="lable-appli-shorting">View</li>
                            <li class="<%= (showList ? "active" : "" ) + " short-list"%>">
                                    <oneit:button   value="List"   name="gotoPage" skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("ShowList", true).toMap())
                                                                    .toMap() %>"/>
                            </li>
                            <li class="<%= (!showList ? "active" : "" ) + " grid-list"%>">
                                    <oneit:button   value="Grid"   name="gotoPage" skin="link"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("ShowList", false).toMap())
                                                                    .toMap() %>"/>
                            </li>
                        </ul>
                <%  }   %>
            </div>
            <div class="shorting-dropdown application_sorting_bar">
                <div class="appli-order-label">Search Applicants</div>
                <oneit:ormInput obj="<%= searchApplicant %>"    type="text" attributeName="Details"    cssClass="form-control search-input"    id="searchText" />
                 <span class="search-icon-btn"></span>
            </div>
            <oneit:button value="Search" name="search" cssClass="btn btn-primary search-real-btn"   style="display:none;"/>
            <%
                if(showOrderBy)
                {
            %>
                    <div class="shorting-dropdown">
                        <span class="appli-order-label">order by</span>
                        <select class="form-control"    onChange="location=this.value">
                        <%
                            for (AppSortOption  sortOption : AppSortOption.getAppSortOptionArray())
                            {
                                String  optionLink  =   applicantsPage + "&AppSortOption=" + sortOption.getName();
                        %>
                                <option <%= (appSortOpt != null && appSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                        </select>
                    </div>
            <%
                }
            %>
            <div class="shorting-dropdown">
                <span class="appli-order-label">Showing</span>
                <select class="form-control status-img"    onChange="location=this.value">
                <%
                    for (ApplicationFilter  applicationFilter : ApplicationFilter.getApplicationFilterArray())
                    {
                        String  optionLink  =   applicantsPage + "&ApplicationFilter=" + applicationFilter.getName();
                %>
                        <option data-image="images/<%= applicationFilter.getName().toLowerCase() %>.png" <%= (appFilter != null && appFilter == applicationFilter ? "selected" : "" )%>  value="<%= optionLink %>">
                            <oneit:toString value="<%= applicationFilter.getDescription() %>"   mode="EscapeHTML"/>
                        </option>
                <%
                    }
                %>
                </select>
            </div>
        </div>
        <div class="checkbox-list select-all">
            <input type='checkbox' id='select_all' value='select_all' class='norecalc'>
            <label for="select_all" class="select-all-jobs">&nbsp;&nbsp;Select all applicants</label>
        </div>
    </div>
        
</oneit:dynIncluded>
