/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package performa.utils;

import java.util.HashMap;
import java.util.Map;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.rdbms.filters.GreaterThanEqualFilter;
import oneit.objstore.rdbms.filters.LessThanEqualFilter;
import performa.orm.Answer;
import performa.orm.Factor;
import performa.orm.FactorQuestionLink;
import performa.orm.FactorScoreResult;
import performa.orm.Level;

/**
 *
 * @author nilu
 */
public class AnalysisEngine 
{
  
    public static void analyseAnswers(Answer[] answers, Level level)
    {
    
        ObjectTransaction       objTran         =   level.getTransaction();
        Map<Factor, Integer>    factorScoreMap  =   new HashMap<>();
        
        for (Answer answer : answers)
        {
            FactorQuestionLink[]    links   = FactorQuestionLink.SearchByAll()
                                                                .andQuestion(new EqualsFilter<>(answer.getQuestion()))
                                                                .search(objTran);
        
            int factorScore = 0;
            
            for (FactorQuestionLink link: links) 
            {
                Factor  factor  =   link.getFactor();
                
                if(factorScoreMap.containsKey(factor))
                {
                    factorScore += factorScoreMap.get(factor);
                }
                
                if(link.getReverseScore().equals("Yes"))
                {
                    // ipsative is stored in quest_hdr. bo not created yet
                    
                    factorScore += (10 - answer.getAnswerNo());
                }
                else
                {
                    factorScore += answer.getAnswerNo();
                }
                
                factorScoreMap.put(factor, factorScore);
            }
        }
        
        for (Map.Entry<Factor, Integer> entrySet : factorScoreMap.entrySet()) 
        {
            Factor  factor      = entrySet.getKey();
            Integer factorScore = entrySet.getValue();
            
            FactorScoreResult result    = FactorScoreResult.SearchByFactorScore()
                                                        .andFactor(new EqualsFilter<>(factor))
                                                        .andLevel(new EqualsFilter<>(level))
                                                        .andFromScore(new LessThanEqualFilter<>(factorScore))
                                                        .andToScore(new GreaterThanEqualFilter<>(factorScore))
                                                        .search(objTran);
                
            
            int score   = result != null ? result.getColorCode().getWeightage() : 0;
            System.out.println("score :: " + score);
            
            // TODO: calculate normalised score based on importance
        }
    }
}