package performa.orm;

import java.util.Arrays;
import java.util.List;
import oneit.objstore.FieldWriteability;
import performa.orm.types.RoleType;


public class CompanyUserHiringTeamLink extends BaseCompanyUserHiringTeamLink
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public CompanyUserHiringTeamLink ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    @Override
    public FieldWriteability getObjectWriteability() 
    {   
        return FieldWriteability.NOT_IN_GUI;
    }
    

    public boolean isOwner()
    {
        return getRole() != null && getRole() == RoleType.OWNER;
    }
    
    
    public boolean showRemoveIcon(CompanyUserHiringTeamLink userLink)
    {
        RoleType    roleType    =   userLink.getRole();

        if(getCompanyUser() == userLink.getCompanyUser() || isOwner())
        {
            return Boolean.FALSE;
        }
        
        if(roleType == RoleType.OWNER || (roleType == RoleType.ADMIN && getRole() == RoleType.STANDARD))
        {
            return Boolean.TRUE;
        }
        
        return Boolean.FALSE;
    }
    
    
    public boolean showEnableIcon(CompanyUserHiringTeamLink userLink)
    {
        RoleType    roleType    =   userLink.getRole();

        if(roleType == RoleType.OWNER || (roleType == RoleType.ADMIN && getRole() == RoleType.STANDARD))
        {
            return Boolean.TRUE;
        }
        
        return Boolean.FALSE;
    }
}