import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { BaseComponent } from '../../base/base.component';
import { AuthService } from '../../services/auth.service';
import { takeUntil } from 'rxjs/operators';

@Component({
    selector: 'app-dashboard',
    templateUrl: './dashboard.component.html',
    styleUrls: ['./dashboard.component.scss']
})
export class DashboardComponent extends BaseComponent implements OnInit {

    showMobileNav;

    constructor(
        private as: AuthService,
        private r: Router
    ) {
        super();
    }

    ngOnInit(): void {
        //
    }

    goToPage(route): void {
        this.r.navigate([route]);
        this.showMobileNav = false;
    }

    logout(): void {
        this.isLoading = true;
        this.as.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.r.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

}
