import { Injectable } from '@angular/core';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { Observable } from 'rxjs';

@Injectable()
export class SearchApplicantService {

    constructor(private searchService : SearchService,
            private utilsService : UtilsService) {

    }

    getApplicants(ob, assocs) {
        return this.searchService.getObjects('Candidates', 'All', ob, assocs, null, null, null, null)
        .map(
            data =>
                this.utilsService.convertResponseToObjects(data, assocs)
        );
    }

    getApplicantByID(id, assocs): Observable<any> {
        return this.searchService.getObjectById("Candidates", id, assocs)
            .map(
                data => {
                    let objs    =   this.utilsService.convertResponseToObjects(data, assocs);
                    
                    if(objs && objs.length > 0){
                        return objs[0];
                    }
                }
            );
    }
}