import { Meteor } from 'meteor/meteor';
import { E_CODE, ERR, PERMISSIONS } from '../config';
import { UtilsService } from '../services/utils.service';
import { settingsCollection } from '../collections/setting.collections';

Meteor.methods({

  updateSettings(setting: any): void {
    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_SETTINGS)) {
      Object.keys(setting)
        .forEach(key => settingsCollection.update({ Key: key }, { $set: { Value: setting[key] } }));
    } else {
      throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
    }
  },

  updateEmailTemplates(setting: any): void {
    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_SETTINGS)) {
      settingsCollection.update(setting.id, {
        $set: {
          Value: {
            SUBJECT: setting.subject,
            CONTENT: setting.content,
          },
        },
      });
    } else {
      throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
    }
  },
});
