import { CONFIG } from '../config';
import { settingsCollection } from '../collections/setting.collections';
import { rolesCollection } from '../collections/role.collection';

export class EmailService {
  static sendVerificationEmail(user: any, userId: string, email = false): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    const mail = email ? email : user.emails[0].address;
    const defaultRole = rolesCollection.findOne(user.profile.role);

    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.verifyEmail = {
      subject() {
        const content: any = settingsCollection.findOne({ Key: 'REGISTER' });

        if (content) {
          return EmailService.formattedContent(
            content.Value.SUBJECT, user.profile.name, defaultRole.title, mail);
        }

        return 'Welcome';
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/verify-email/${token}`;
        const content: any = settingsCollection.findOne({ Key: 'REGISTER' });

        return EmailService.formattedContent(
          content.Value.CONTENT, user.profile.name, defaultRole.title, mail, link);
      },
    };

    Accounts.sendVerificationEmail(userId, mail);
  }

  static sendForgotPasswordEmail(user: Meteor.User, email: string): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    const mail = email ? email : user.emails[0].address;
    const defaultRole = rolesCollection.findOne(user.profile.role);

    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.resetPassword = {
      subject() {
        const content: any = settingsCollection.findOne({ Key: 'RESET' });

        if (content) {
          return EmailService.formattedContent(
            content.Value.SUBJECT, user.profile.name, defaultRole.title, mail);
        }

        return 'Reset Password';
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/reset-password/${token}`;
        const content: any = settingsCollection.findOne({ Key: 'RESET' });

        return EmailService.formattedContent(
          content.Value.CONTENT, user.profile.name, defaultRole.title, mail, link);
      },
    };

    Accounts.sendResetPasswordEmail(user._id, email);
  }

  static formattedContent(content: string, name: string, role: string, email, link = null): string {
    const str = content.replace(/\$name/g, name)
      .replace(/\$role/g, role)
      .replace(/\$platform/g, CONFIG.SiteName)
      .replace(/\$email/g, email);

    return link ? str.replace(/\$link/g, link) : str;
  }
}
