import { Meteor } from 'meteor/meteor';
import { rolesCollection } from '../collections/role.collection';
import { ERR, E_CODE, PERMISSIONS } from '../config';
import { UtilsService } from '../services/utils.service';
import { EmailService } from '../services/email.service';

Meteor.methods({

  registerUser(user: any): string {
    const defaultRole = rolesCollection.findOne({ title: user.role });

    if (!Accounts.findUserByEmail(user.email)) {
      const userObj = {
        email: user.email,
        password: user.password,
        username: user.username,
        profile: {
          name: user.name,
          role: defaultRole._id,
        },
      };
      const userId = Accounts.createUser(userObj);
      const usr = Accounts.findUserByUsername(user.username);
      EmailService.sendVerificationEmail(usr, userId);

      return userId;
    }
    throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.EMAIL_EXISTS);
  },

  verifyEmailAddress(user: any): any {
    if (Accounts.findUserByEmail(user.email)) {
      const usr = Accounts.findUserByEmail(user.email);
      EmailService.sendVerificationEmail(usr, user._id, user.email);

      return true;
    }
    throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.EMAIL_EXISTS);
  },

  updateUser(user: any): any {
    if (!user._id) {
      throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.ID_MISSING);
    }

    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_ALL_USERS) ||
      (
        UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_OWN_USER)
        && user._id === Meteor.user()._id
      )) {
      const updateObj = { $set: { profile: user.profile } };
      return Meteor.users.update(user._id, updateObj);
    }

    throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
  },

  addEmailAddress(user: any): any {
    if (!user._id || !user.email) {
      throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.DATA_MISSING);
    }

    if (Accounts.findUserByEmail(user.email)) {
      throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.EMAIL_EXISTS);
    }

    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_ALL_USERS) ||
      (
        UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_OWN_USER)
        && user._id === Meteor.user()._id
      )) {
      Accounts.addEmail(user._id, user.email);
      return true;
    }
    throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
  },

  removeEmailAddress(user: any): any {
    if (!user._id || !user.email) {
      throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.DATA_MISSING);
    }

    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_ALL_USERS) ||
      (
        UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_OWN_USER)
        && user._id === Meteor.user()._id
      )) {
      Accounts.removeEmail(user._id, user.email);
      return true;
    }

    throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
  },

  checkUserByEmail(email: string): any {
    return Accounts.findUserByEmail(email);
  },

});
