import { Meteor } from 'meteor/meteor';
import { first } from 'rxjs/operators';
import { rolesCollection } from '../collections/role.collection';
import { E_CODE, PERMISSIONS } from '../config';
import { RoleModel } from '../models/role.model';
import { UtilsService } from '../services/utils.service';

Meteor.methods({
  async saveRole(role: RoleModel): Promise<void> {
    try {
      if (role._id && UtilsService.hasPermission(PERMISSIONS.UPDATE_ROLE)) {
        await rolesCollection.update(role._id, role)
          .pipe(first())
          .toPromise();
      }
    } catch (e) {
      throw new Meteor.Error(E_CODE.SERVER_ERROR, JSON.stringify(e));
    }
  },
});
