import { Meteor } from 'meteor/meteor';
// tslint:disable-next-line:ban-ts-ignore
// @ts-ignore
import { publishComposite } from 'meteor/reywood:publish-composite';
import { E_CODE, ERR, PERMISSIONS } from '../config';
import { QueryModel } from '../models/query.model';
import { UtilsService } from '../services/utils.service';
import { rolesCollection } from '../collections/role.collection';

publishComposite('usersList', (filters = {}) => {

  const queryFilters = { ...new QueryModel(), ...filters };

  if (!UtilsService.hasPermission([PERMISSIONS.CAN_SEE_ALL_USERS])) {
    throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
  }

  return {
    find(): any {
      return Meteor.users.find(queryFilters.query, { ...queryFilters.options });
    },
    children: [
      {
        find(user): any {
          return rolesCollection.find({ _id: user.profile.role });
        },
      },
    ],
  };
});
