import { Meteor } from 'meteor/meteor';
import { PERMISSIONS } from './config';
import { UtilsService } from './services/utils.service';

Meteor.startup(() => {
  // @ts-ignore
  Migrations.migrateTo('latest');
  // Validate Login Attempt
  Accounts.validateLoginAttempt((data): boolean => {
    const user: Meteor.User = data.user;

    return user && user.profile.role
      && UtilsService.hasPermissionOfUser(user, PERMISSIONS.CAN_LOGIN);
  });

  // Changing url of reset password
  Accounts.emailTemplates.resetPassword.text = (user, url) => {
    const token = url.substring(url.lastIndexOf('/') + 1, url.length);

    return Meteor.absoluteUrl(`auth/reset-password/${token}`);
  };
});
