import { CONFIG } from '../config';
import { settingsCollection } from '../collections/setting.collections';

export class EmailService {
  static sendVerificationEmail(user: any, userId: string): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.verifyEmail = {
      subject() {
        const content: any = settingsCollection.findOne({ REGISTER_HEADING: { $exists: true } });
        return content ? content.REGISTER_HEADING.replace('$platform', CONFIG.SiteName) : 'Welcome';
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/verify-email/${token}`;
        const content: any = settingsCollection.findOne({ REGISTER_EMAIL_BODY: { $exists: true } });
        return content.REGISTER_EMAIL_BODY.replace(/\$name/g, user.name)
          .replace(/\$role/g, user.role)
          .replace(/\$link/g, link);
      },
    };

    Accounts.sendVerificationEmail(userId, user.email);
  }

  static sendForgotPasswordEmail(user: Meteor.User, email: string): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.resetPassword = {
      subject() {
        const content: any = settingsCollection.findOne({ RESET_HEADING: { $exists: true } });
        return content ? content.RESET_HEADING.replace('$platform', CONFIG.SiteName) : 'Welcome';
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/reset-password/${token}`;
        const content: any = settingsCollection.findOne({ RESET_EMAIL_BODY: { $exists: true } });
        return content.RESET_EMAIL_BODY.replace(/\$name/g, user.profile.name)
          .replace(/\$link/g, link);
      },
    };

    Accounts.sendResetPasswordEmail(user._id, email);
  }
}
