import { settingsCollection } from './collections/setting.collections';
import { PERMISSIONS } from './config';
import { rolesCollection } from './collections/role.collection';
import { Meteor } from 'meteor/meteor';

// @ts-ignore
Migrations.add({
  version: 1,
  name: 'Adding Roles',
  up() {
    const allPermissions = Object.values(PERMISSIONS);

    if (!rolesCollection.find({}).fetch().length) {
      rolesCollection.insert({
        title: 'Admin',
        permissions: allPermissions,
        description: '',
      });
      rolesCollection.insert({
        title: 'User',
        permissions: [PERMISSIONS.CAN_LOGIN, PERMISSIONS.CAN_UPDATE_OWN_USER],
        description: '',
      });
      rolesCollection.insert({
        title: 'Blocked',
        permissions: [],
        description: '',
      });
    } else {
      rolesCollection.update({ title: 'Admin' }, { $set: { permissions: allPermissions } });
    }
  },
});

// @ts-ignore
Migrations.add({
  version: 2,
  name: 'Adding Admin User',
  up() {
    if (!Meteor.users.find({}).fetch().length) {
      Accounts.createUser({
        username: 'admin',
        password: 'admin',
        email: 'ali.arshad@vqode.com',
        profile: {
          name: 'Admin User',
          role: rolesCollection.findOne({ title: 'Admin' })._id,
        },
      });
    }
  },
});

// @ts-ignore
Migrations.add({
  version: 3,
  name: 'Adding Email Templates',
  up() {
    if (settingsCollection.find({ REGISTER_HEADING: { $exists: true } }).fetch().length === 0) {
      settingsCollection.insert({ REGISTER_HEADING: 'Welcome to $platform' });
    }
    if (settingsCollection.find({ REGISTER_EMAIL_BODY: { $exists: true } }).fetch().length === 0) {
      settingsCollection.insert({ REGISTER_EMAIL_BODY: 'Hi $name! You are our $role now. Please click on the link <a href="$link" target="_blank">$link</a> to verify your account.' });
    }
    if (settingsCollection.find({ RESET_HEADING: { $exists: true } }).fetch().length === 0) {
      settingsCollection.insert({ RESET_HEADING: 'Reset Password for $platform' });
    }
    if (settingsCollection.find({ RESET_EMAIL_BODY: { $exists: true } }).fetch().length === 0) {
      settingsCollection.insert({ RESET_EMAIL_BODY: 'Hi $name! Don\'t worry. Reset your password by clicking on the following link <a href="$link" target="_blank">$link</a>.' });
    }
  },
});
