import { Meteor } from 'meteor/meteor';
import { rolesCollection } from '../collections/role.collection';
import { PERMISSIONS } from '../config';
import { UtilsService } from '../services/utils.service';
import { QueryModel } from '../models/query.model';
import { EmailService } from '../services/email.service';

Meteor.methods({

  usersGetCount(query: QueryModel): any {
    return {
      recordsFiltered: Meteor.users.find(query.query).count(),
      recordsTotal: Meteor.users.find().count(),
    };

  },

  registerUser(user: any): string {
    const defaultRole = rolesCollection.findOne({ title: user.role });
    if (!Accounts.findUserByEmail(user.email)) {
      const userObj = {
        email: user.email,
        password: user.password,
        username: user.username,
        profile: {
          name: user.name,
          role: defaultRole._id,
        },
      };
      const userId = Accounts.createUser(userObj);
      EmailService.sendVerificationEmail(user, userId);

      return userId;
    }
    throw new Meteor.Error(422, 'Email address already in use.');
  },

  updateUser(user: any): any {
    if (!UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_OWN_USER)) {
      throw new Meteor.Error(403, 'Forbidden.');
    }

    if (user._id) {
      if (user.password) {
        Accounts.setPassword(user._id, user.password);
      }
      const updateObj = { $set: { profile: user.profile } };

      return Meteor.users.update(user._id, updateObj);
    }
  },

  checkUserByEmail(email: string): any {
    return Accounts.findUserByEmail(email);
  },

});
