import { settingsCollection } from '../collections/setting.collections';
import { UtilsService } from '../services/utils.service';
import { E_CODE, ERR, PERMISSIONS } from '../config';
import { Meteor } from 'meteor/meteor';

Meteor.publish('settings', (filter: any = {}) => {
  if (UtilsService.hasPermission(PERMISSIONS.CAN_ACCESS_SETTINGS)) {
    if (filter.IsEmail && !UtilsService.hasPermission(PERMISSIONS.CAN_ACCESS_EMAIL_TEMPLATES)) {
      throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
    }
    return settingsCollection.find(filter);
  }
  throw new Meteor.Error(E_CODE.FORBIDDEN, ERR.FORBIDDEN);
});
