import { Meteor } from 'meteor/meteor';
import { EmailService } from '../services/email.service';
import { E_CODE, ERR } from '../config';

Meteor.methods({
  sendForgotPasswordEmail(email: string): boolean {
    const user: Meteor.User = Accounts.findUserByEmail(email);
    if (user) {
      EmailService.sendForgotPasswordEmail(user, email);
      return true;
    }
    throw new Meteor.Error(E_CODE.UNPROCESSABLE_ENTITY, ERR.EMAIL_NOT_EXISTS);
  },
});
