import { CONFIG } from '../config';
import { settingsCollection } from '../collections/setting.collections';
import { rolesCollection } from "../collections/role.collection";

export class EmailService {
  static sendVerificationEmail(user: any, userId: string, email = false): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    const defaultRole = rolesCollection.findOne(user.profile.role);
    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.verifyEmail = {
      subject() {
        const content: any = settingsCollection.findOne({ Key: 'REGISTER' });
        return content ? content.Value.SUBJECT.replace('$platform', CONFIG.SiteName) : 'Welcome';
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/verify-email/${token}`;
        const content: any = settingsCollection.findOne({ Key: 'REGISTER' });
        return content.Value.CONTENT.replace(/\$name/g, user.profile.name)
          .replace(/\$role/g, defaultRole.title)
          .replace(/\$link/g, link);
      },
    };
    const mail = email ? email : user.emails[0].address;
    console.log(mail, userId);

    Accounts.sendVerificationEmail(userId, mail);
  }

  static sendForgotPasswordEmail(user: Meteor.User, email: string): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.resetPassword = {
      subject() {
        const content: any = settingsCollection.findOne({ Key: 'RESET' });
        return content ? content.Value.SUBJECT.replace('$platform', CONFIG.SiteName) : 'Welcome';
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/reset-password/${token}`;
        const content: any = settingsCollection.findOne({ Key: 'RESET' });
        return content.Value.CONTENT.replace(/\$name/g, user.profile.name)
          .replace(/\$link/g, link);
      },
    };

    Accounts.sendResetPasswordEmail(user._id, email);
  }
}
