import { settingsCollection } from '../collections/setting.collections';
import { UtilsService } from '../services/utils.service';
import { PERMISSIONS } from '../config';
import { Meteor } from 'meteor/meteor';

Meteor.publish('settings', () => {
  if (UtilsService.hasPermission(PERMISSIONS.CAN_ACCESS_SETTINGS)) {
    return settingsCollection.find({});
  }
  throw new Meteor.Error(403, 'Not Enough Permissions');
});

Meteor.publish('email-templates', () => {
  if (UtilsService.hasPermission(PERMISSIONS.CAN_ACCESS_EMAIL_TEMPLATES)) {
    return settingsCollection.find({ IsEmail: true });
  }
  throw new Meteor.Error(403, 'Not Enough Permissions');
});
