import { settingsCollection } from './collections/setting.collections';
import { PERMISSIONS, ROLE_RANK } from './config';
import { rolesCollection } from './collections/role.collection';
import { Meteor } from 'meteor/meteor';

// @ts-ignore
Migrations.add({
  version: 1,
  name: 'Adding Roles',
  up() {
    const allPermissions = Object.values(PERMISSIONS);

    if (!rolesCollection.find({}).fetch().length) {
      rolesCollection.insert({
        title: 'Admin',
        permissions: allPermissions,
        description: '',
        Slug: ROLE_RANK.ADMIN,
      });
      rolesCollection.insert({
        title: 'User',
        permissions: [PERMISSIONS.CAN_LOGIN, PERMISSIONS.CAN_UPDATE_OWN_USER],
        description: '',
        Slug: ROLE_RANK.USER,
      });
      rolesCollection.insert({
        title: 'Blocked',
        permissions: [],
        description: '',
        Slug: ROLE_RANK.BLOCKED,
      });
    } else {
      rolesCollection.update({ title: 'Admin' }, { $set: { permissions: allPermissions } });
    }
  },
});

// @ts-ignore
Migrations.add({
  version: 2,
  name: 'Adding Admin & User',
  up() {
    if (!Meteor.users.find({}).fetch().length) {
      Accounts.createUser({
        username: 'admin',
        password: 'Admin123',
        email: 'ali.arshad@vqode.com',
        profile: {
          name: 'Admin User',
          role: rolesCollection.findOne({ title: 'Admin' })._id,
        },
      });
      Accounts.createUser({
        username: 'lead',
        password: 'Qweasdzxc1',
        email: 'lead@mailinator.com',
        profile: {
          name: 'Lead',
          role: rolesCollection.findOne({ title: 'User' })._id,
        },
      });
    }
  },
});

// @ts-ignore
Migrations.add({
  version: 3,
  name: 'Adding Email Templates',
  up() {
    if (settingsCollection.find({ Key: 'REGISTER' }).fetch().length === 0) {
      settingsCollection.insert({
        Key: 'REGISTER',
        Value: {
          SUBJECT: 'Welcome to $platform',
          CONTENT: 'Hi $name! You are our $role now. Please click on the link <a href="$link" target="_blank">$link</a> to verify your account.',
        },
        Description: 'Register Email Template',
        IsEmail: true,
      });
    }

    if (settingsCollection.find({ Key: 'RESET' }).fetch().length === 0) {
      settingsCollection.insert({
        Key: 'RESET',
        Value: {
          SUBJECT: 'Reset Password for $platform',
          CONTENT: 'Hi $name! Don\'t worry. Reset your password by clicking on the following link <a href="$link" target="_blank">$link</a>.',
        },
        Description: 'Reset Password Email Template',
        IsEmail: true,
      });
    }
  },
});
