import { Meteor } from 'meteor/meteor';
import { PERMISSIONS } from '../config';
import { UtilsService } from '../services/utils.service';
import { settingsCollection } from '../collections/setting.collections';

Meteor.methods({

  updateSettings(setting: any): void {
    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_SETTINGS)) {
      settingsCollection.update(setting.id, {
        $set: {
          Value: {
            SUBJECT: setting.subject,
            CONTENT: setting.content,
          },
        },
      });
    } else {
      throw new Meteor.Error(403, 'Not Enough Permissions');
    }
  },

  updateEmailTemplates(setting: any): void {
    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_SETTINGS)) {
      settingsCollection.update(setting.id, {
        $set: {
          Value: {
            SUBJECT: setting.subject,
            CONTENT: setting.content,
          },
        },
      });
    } else {
      throw new Meteor.Error(403, 'Not Enough Permissions');
    }
  },
});
