import { Meteor } from 'meteor/meteor';
import { EmailService } from '../services/email.service';

Meteor.methods({
  sendForgotPasswordEmail(email: string): boolean {
    const user: Meteor.User = Accounts.findUserByEmail(email);
    if (user) {
      EmailService.sendForgotPasswordEmail(user, email);
      return true;
    }
    throw new Meteor.Error(422, 'Email address doesn\'t exist.');
  },
});
