/* tslint:disable:no-require-imports */
// tslint:disable-next-line:import-name
import S3 from 'aws-sdk/clients/s3';
import { FilesCollection } from 'meteor/ostrio:files';
import '../env';

const allowedExt = ['mp3', 'png', 'jpg', 'jpeg', 'gif'];
let s3Client;
let s3Conf;
let sendToStorage;
let interceptDownload;
let fileDir = './';
const bound = Meteor.bindEnvironment((callback) => {
  return callback();
});

if (Meteor.isServer) {
  const fs = require('fs');
  const path = require('path');
  const stream = require('stream');
  const os = require('os');

  fileDir = os.tmpdir();
  s3Conf = JSON.parse(process.env.S3);
  s3Client = new S3({
    secretAccessKey: s3Conf.secret,
    accessKeyId: s3Conf.key,
    region: s3Conf.region,
    sslEnabled: false,
    httpOptions: {
      timeout: 6000,
    },
  });

  sendToStorage = (fileRef) => {
    const filePath = path.join(s3Conf.path, fileRef._id + fileRef.extensionWithDot);
    s3Client.putObject(
      {
        StorageClass: 'STANDARD',
        Bucket: s3Conf.bucket,
        Key: filePath,
        Body: fs.createReadStream(fileRef.path),
        ContentType: fileRef.type,
      },
      (error) => {
        bound(() => {
          if (error) {
            // console.error(error);
          } else {
            files.update({ _id: fileRef._id }, { $set: { uploadedToS3: true } });
            if (fs.existsSync(fileRef.path)) {
              fs.unlink(fileRef.path);
            }
          }
        });
      });
  };

  interceptDownload = function (http, fileRef, version): boolean {
    const filePath = path.join(s3Conf.path, fileRef._id + fileRef.extensionWithDot);
    if (!fileRef.uploadedToS3) {
      return false;
    }
    const opts = {
      Bucket: s3Conf.bucket,
      Key: filePath,
      Range: '',
    };

    if (http.request.headers.range) {
      const vRef = fileRef.versions[version];
      const range = JSON.parse(JSON.stringify(http.request.headers.range));
      const array = range.split(/bytes=([0-9]*)-([0-9]*)/);
      const start = parseInt(array[1], 10);
      let end = parseInt(array[2], 10);
      if (isNaN(end)) {
        // Request data from AWS:S3 by small chunks
        end = (start + this.chunkSize) - 1;
        if (end >= vRef.size) {
          end = vRef.size - 1;
        }
      }
      opts.Range = `bytes=${start}-${end}`;
      http.request.headers.range = `bytes=${start}-${end}`;
    }

    s3Client.getObject(opts, (error, data) => {
      if (error) {
        // console.error(error);
        if (!http.response.finished) {
          http.response.end();
        }
      } else {
        if (http.request.headers.range && data.httpResponse && data.httpResponse.headers['content-range']) {
          // Set proper range header in according to what is returned from AWS:S3
          http.request.headers.range = data.httpResponse.headers['content-range'].split('/')[0]
            .replace('bytes ', 'bytes=');
        }

        const dataStream = new stream.PassThrough();
        this.serve(http, fileRef, fileRef.versions[version], version, dataStream);
        dataStream.end(data.Body);
      }
    });

    return true;
  };
}

const onBeforeUpload = (fileRef) => {
  if (allowedExt.indexOf(fileRef.ext) === -1) {
    return `Only ${allowedExt.join(', ')} files are allowed.`;
  }

  if (fileRef.size <= 1024 * 1024 * 128) {
    return true;
  }

  return 'Max. file size allowed is 50MB';
};

const onAfterUpload = (fileRef) => {
  if (Meteor.isServer) {
    sendToStorage(fileRef);
  }
};

export const files = new FilesCollection({
  onBeforeUpload,
  onAfterUpload,
  interceptDownload,
  collectionName: 'files',
  storagePath: fileDir,
  allowClientCode: true,
});

if (Meteor.isServer) {
  files.denyClient();
}

if (Meteor.isClient) {
  Meteor.subscribe('files.images.all');
}

if (Meteor.isServer) {
  Meteor.publish('files.images.all', () => files.collection.find({}));
}
